/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.joda.time.DateMidnight;
import org.joda.time.LocalDate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ClassUtils;

public abstract class CassandraJodaTimeConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    private CassandraJodaTimeConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JODA_TIME_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(CassandraLocalDateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToCassandraLocalDateConverter.INSTANCE);
        converters.add(CassandraLocalDateToDateMidnightConverter.INSTANCE);
        converters.add(DateMidnightToCassandraLocalDateConverter.INSTANCE);
        return converters;
    }

    public static enum DateMidnightToCassandraLocalDateConverter implements Converter<DateMidnight, com.datastax.driver.core.LocalDate>
    {
        INSTANCE;


        public com.datastax.driver.core.LocalDate convert(DateMidnight source) {
            return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)source.getYear(), (int)source.getMonthOfYear(), (int)source.getDayOfMonth());
        }
    }

    public static enum CassandraLocalDateToDateMidnightConverter implements Converter<com.datastax.driver.core.LocalDate, DateMidnight>
    {
        INSTANCE;


        public DateMidnight convert(com.datastax.driver.core.LocalDate source) {
            return new DateMidnight(source.getYear(), source.getMonth(), source.getDay());
        }
    }

    public static enum LocalDateToCassandraLocalDateConverter implements Converter<LocalDate, com.datastax.driver.core.LocalDate>
    {
        INSTANCE;


        public com.datastax.driver.core.LocalDate convert(LocalDate source) {
            return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)source.getYear(), (int)source.getMonthOfYear(), (int)source.getDayOfMonth());
        }
    }

    public static enum CassandraLocalDateToLocalDateConverter implements Converter<com.datastax.driver.core.LocalDate, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(com.datastax.driver.core.LocalDate source) {
            return new LocalDate(source.getYear(), source.getMonth(), source.getDay());
        }
    }
}

