/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.convert.BasicCassandraRowValueProvider;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.convert.CassandraPersistentEntityParameterValueProvider;
import org.springframework.data.cassandra.convert.CassandraRowValueProvider;
import org.springframework.data.cassandra.convert.CassandraUDTValueProvider;
import org.springframework.data.cassandra.convert.CassandraValueProvider;
import org.springframework.data.cassandra.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.mapping.BasicCassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.MapIdentifiable;
import org.springframework.data.cassandra.repository.support.BasicMapId;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements CassandraConverter,
ApplicationContextAware,
BeanClassLoaderAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CassandraMappingContext mappingContext;
    private ClassLoader beanClassLoader;
    private SpELContext spELContext;

    public MappingCassandraConverter() {
        this(new BasicCassandraMappingContext());
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super((ConversionService)new DefaultConversionService());
        Assert.notNull((Object)mappingContext, (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        ClassTypeInformation typeInfo = ClassTypeInformation.from(beanClassLoaderClass);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return (R)row;
        }
        if (this.getCustomConversions().hasCustomReadTarget(Row.class, rawType) || this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        if (typeInfo.isCollectionLike() || typeInfo.isMap()) {
            return (R)this.getConversionService().convert((Object)row, type);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity((TypeInformation)typeInfo);
        if (persistentEntity == null) {
            throw new MappingException(String.format("No mapping metadata found for %s", rawType.getName()));
        }
        return (R)this.readEntityFromRow(persistentEntity, row);
    }

    protected <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator((Object)row, this.spELContext);
        BasicCassandraRowValueProvider rowValueProvider = new BasicCassandraRowValueProvider(row, expressionEvaluator);
        CassandraPersistentEntityParameterValueProvider parameterProvider = new CassandraPersistentEntityParameterValueProvider((PersistentEntity<?, CassandraPersistentProperty>)entity, new MappingAndConvertingValueProvider(rowValueProvider), null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)parameterProvider);
        this.readPropertiesFromRow(entity, rowValueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(instance, entity));
        return (S)instance;
    }

    protected <S> S readEntityFromUdt(CassandraPersistentEntity<S> entity, UDTValue udtValue) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator((Object)udtValue, this.spELContext);
        CassandraUDTValueProvider valueProvider = new CassandraUDTValueProvider(udtValue, CodecRegistry.DEFAULT_INSTANCE, expressionEvaluator);
        PersistentEntityParameterValueProvider<CassandraPersistentProperty> parameterValueProvider = this.getParameterValueProvider(entity, valueProvider);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, parameterValueProvider);
        this.readProperties(entity, valueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(instance, entity));
        return (S)instance;
    }

    private <S> PersistentEntityParameterValueProvider<CassandraPersistentProperty> getParameterValueProvider(CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        return new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new MappingAndConvertingValueProvider(valueProvider), null);
    }

    protected void readPropertiesFromRow(CassandraPersistentEntity<?> entity, CassandraRowValueProvider row, PersistentPropertyAccessor propertyAccessor) {
        this.readProperties(entity, row, propertyAccessor);
    }

    protected void readProperties(final CassandraPersistentEntity<?> entity, final CassandraValueProvider valueProvider, final PersistentPropertyAccessor propertyAccessor) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                MappingCassandraConverter.this.readProperty(entity, property, valueProvider, propertyAccessor);
            }
        });
    }

    @Deprecated
    protected void readPropertyFromRow(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraRowValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        this.readProperty(entity, property, valueProvider, propertyAccessor);
    }

    protected void readProperty(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        if (entity.isConstructorArgument(property)) {
            return;
        }
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentProperty keyProperty = (CassandraPersistentProperty)entity.getIdProperty();
            CassandraPersistentEntity<?> keyEntity = keyProperty.getCompositePrimaryKeyEntity();
            Object key = propertyAccessor.getProperty((PersistentProperty)keyProperty);
            if (key == null) {
                key = this.instantiatePrimaryKey(keyEntity, keyProperty, valueProvider);
            }
            this.readProperties(property.getCompositePrimaryKeyEntity(), valueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(key, keyEntity));
            propertyAccessor.setProperty((PersistentProperty)keyProperty, key);
            return;
        }
        if (!valueProvider.hasProperty(property)) {
            return;
        }
        propertyAccessor.setProperty((PersistentProperty)property, this.getReadValue(valueProvider, property));
    }

    protected Object instantiatePrimaryKey(CassandraPersistentEntity<?> entity, CassandraPersistentProperty keyProperty, CassandraValueProvider propertyProvider) {
        return this.instantiators.getInstantiatorFor(entity).createInstance(entity, this.getParameterValueProvider(entity, propertyProvider));
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException("Unknown row object " + ObjectUtils.nullSafeClassName((Object)row));
    }

    @Override
    public Object convertToCassandraColumn(Object obj, TypeInformation<?> typeInformation) {
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null!");
        if (obj == null || obj.getClass().isArray()) {
            return obj;
        }
        return this.getWriteValue(obj, typeInformation);
    }

    public void write(Object source, Object sink) {
        if (source != null) {
            Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
            CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(beanClassLoaderClass);
            this.write(source, sink, entity);
        }
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        if (source == null) {
            return;
        }
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Map) {
            this.writeMapFromWrapper(this.getConvertingAccessor(source, entity), (Map)sink, entity);
        } else if (sink instanceof Insert) {
            this.writeInsertFromObject(source, (Insert)sink, entity);
        } else if (sink instanceof Update) {
            this.writeUpdateFromObject(source, (Update)sink, entity);
        } else if (sink instanceof Select.Where) {
            this.writeSelectWhereFromObject(source, (Select.Where)sink, entity);
        } else if (sink instanceof Delete.Where) {
            this.writeDeleteWhereFromObject(source, (Delete.Where)sink, entity);
        } else if (sink instanceof UDTValue) {
            this.writeUDTValueWhereFromObject(this.getConvertingAccessor(source, entity), (UDTValue)sink, entity);
        } else {
            throw new MappingException("Unknown write target " + sink.getClass().getName());
        }
    }

    protected void writeInsertFromObject(Object object, Insert insert, CassandraPersistentEntity<?> entity) {
        this.writeInsertFromWrapper(this.getConvertingAccessor(object, entity), insert, entity);
    }

    private void writeMapFromWrapper(final ConvertingPropertyAccessor accessor, final Map<String, Object> insert, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                Object value = MappingCassandraConverter.this.getWriteValue(property, accessor);
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
                }
                if (property.isCompositePrimaryKey()) {
                    if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                        MappingCassandraConverter.this.log.debug("Property is a compositeKey");
                    }
                    MappingCassandraConverter.this.writeMapFromWrapper(MappingCassandraConverter.this.getConvertingAccessor(value, property.getCompositePrimaryKeyEntity()), insert, property.getCompositePrimaryKeyEntity());
                    return;
                }
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("Adding map.entry [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
                }
                insert.put(property.getColumnName().toCql(), value);
            }
        });
    }

    protected void writeInsertFromWrapper(final ConvertingPropertyAccessor accessor, final Insert insert, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                Object value = MappingCassandraConverter.this.getWriteValue(property, accessor);
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
                }
                if (property.isCompositePrimaryKey()) {
                    if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                        MappingCassandraConverter.this.log.debug("Property is a compositeKey");
                    }
                    MappingCassandraConverter.this.writeInsertFromWrapper(MappingCassandraConverter.this.getConvertingAccessor(value, property.getCompositePrimaryKeyEntity()), insert, property.getCompositePrimaryKeyEntity());
                    return;
                }
                if (value == null) {
                    return;
                }
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("Adding insert.value [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
                }
                insert.value(property.getColumnName().toCql(), value);
            }
        });
    }

    protected void writeUpdateFromObject(Object object, Update update, CassandraPersistentEntity<?> entity) {
        this.writeUpdateFromWrapper(this.getConvertingAccessor(object, entity), update, entity);
    }

    protected void writeUpdateFromWrapper(final ConvertingPropertyAccessor accessor, final Update update, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                Object value = MappingCassandraConverter.this.getWriteValue(property, accessor);
                if (property.isCompositePrimaryKey()) {
                    CassandraPersistentEntity<?> keyEntity = property.getCompositePrimaryKeyEntity();
                    MappingCassandraConverter.this.writeUpdateFromWrapper(MappingCassandraConverter.this.getConvertingAccessor(value, keyEntity), update, keyEntity);
                    return;
                }
                if (MappingCassandraConverter.this.isPrimaryKeyPart(property)) {
                    update.where(QueryBuilder.eq((String)property.getColumnName().toCql(), (Object)value));
                } else {
                    update.with(QueryBuilder.set((String)property.getColumnName().toCql(), (Object)value));
                }
            }
        });
    }

    protected void writeSelectWhereFromObject(Object object, Select.Where where, CassandraPersistentEntity<?> entity) {
        Collection<Clause> clauses = this.getWhereClauses(object, entity);
        for (Clause clause : clauses) {
            where.and(clause);
        }
    }

    protected void writeDeleteWhereFromObject(Object object, Delete.Where where, CassandraPersistentEntity<?> entity) {
        Collection<Clause> clauses = this.getWhereClauses(object, entity);
        for (Clause clause : clauses) {
            where.and(clause);
        }
    }

    protected void writeUDTValueWhereFromObject(final ConvertingPropertyAccessor accessor, final UDTValue udtValue, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                Object value = MappingCassandraConverter.this.getWriteValue(property, accessor);
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("writeUDTValueWhereFromObject Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
                }
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("Adding udt.value [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
                }
                TypeCodec typeCodec = CodecRegistry.DEFAULT_INSTANCE.codecFor(MappingCassandraConverter.this.getMappingContext().getDataType(property));
                udtValue.set(property.getColumnName().toCql(), value, typeCodec);
            }
        });
    }

    private Collection<Clause> getWhereClauses(Object source, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        Object id = this.extractId(source, entity);
        Assert.notNull((Object)id, (String)String.format("No Id value found in object %s", source));
        if (id instanceof MapId) {
            return this.getWhereClauses((MapId)id, idProperty != null && idProperty.isCompositePrimaryKey() ? idProperty.getCompositePrimaryKeyEntity() : entity);
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (idProperty.isCompositePrimaryKey()) {
            if (ClassUtils.isAssignableValue((Class)idProperty.getType(), (Object)id)) {
                return this.getWhereClauses(this.getConvertingAccessor(id, idProperty.getCompositePrimaryKeyEntity()), idProperty.getCompositePrimaryKeyEntity());
            }
            throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
        }
        Class<?> targetType = this.getTargetType(idProperty);
        if (this.getConversionService().canConvert(id.getClass(), targetType)) {
            return Collections.singleton(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)this.getPotentiallyConvertedSimpleValue(id, targetType)));
        }
        return Collections.singleton(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)id));
    }

    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private Collection<Clause> getWhereClauses(final ConvertingPropertyAccessor accessor, CassandraPersistentEntity<?> entity) {
        Assert.isTrue((boolean)entity.isCompositePrimaryKey(), (String)String.format("Entity [%s] is not a composite primary key", entity.getName()));
        final ArrayList<Clause> clauses = new ArrayList<Clause>();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                TypeCodec codec = MappingCassandraConverter.this.getCodec(property);
                Object value = accessor.getProperty((PersistentProperty)property, codec.getJavaType().getRawType());
                clauses.add(QueryBuilder.eq((String)property.getColumnName().toCql(), (Object)value));
            }
        });
        return clauses;
    }

    private Collection<Clause> getWhereClauses(MapId id, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            Assert.notNull((Object)persistentProperty, (String)String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            clauses.add(QueryBuilder.eq((String)persistentProperty.getColumnName().toCql(), (Object)this.getWriteValue(entry.getValue(), persistentProperty.getTypeInformation())));
        }
        return clauses;
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        final ConvertingPropertyAccessor accessor = this.getConvertingAccessor(object, entity);
        Assert.isTrue((boolean)entity.getType().isAssignableFrom(object.getClass()), (String)String.format("Given instance of type [%s] is not of compatible expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return accessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getTargetType(idProperty));
        }
        final MapId id = BasicMapId.id();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isPrimaryKeyColumn()) {
                    id.with(property.getName(), (Serializable)MappingCassandraConverter.this.getWriteValue(property, accessor));
                }
            }
        });
        return id;
    }

    protected <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException e) {
            return entity;
        }
        catch (LinkageError e) {
            return entity;
        }
    }

    private ConvertingPropertyAccessor getConvertingAccessor(Object source, CassandraPersistentEntity<?> entity) {
        PersistentPropertyAccessor propertyAccessor = source instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)source : entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(propertyAccessor, this.getConversionService());
    }

    private boolean isPrimaryKeyPart(CassandraPersistentProperty property) {
        return property.isCompositePrimaryKey() || property.isPrimaryKeyColumn() || property.isIdProperty();
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        if (this.getCustomConversions().hasCustomWriteTarget(property.getType())) {
            return this.getCustomConversions().getCustomWriteTarget(property.getType());
        }
        if (property.findAnnotation(CassandraType.class) != null) {
            return this.getPropertyTargetType(property);
        }
        if (property.isCompositePrimaryKey() || this.getCustomConversions().isSimpleType(property.getType()) || property.isCollectionLike()) {
            return property.getType();
        }
        return this.getPropertyTargetType(property);
    }

    private Class<?> getPropertyTargetType(CassandraPersistentProperty property) {
        DataType dataType = this.getMappingContext().getDataType(property);
        if (dataType instanceof UserType) {
            return property.getType();
        }
        TypeCodec codec = CodecRegistry.DEFAULT_INSTANCE.codecFor(this.getMappingContext().getDataType(property));
        return codec.getJavaType().getRawType();
    }

    private Object getWriteValue(CassandraPersistentProperty property, ConvertingPropertyAccessor accessor) {
        return this.getWriteValue(accessor.getProperty((PersistentProperty)property, this.getTargetType(property)), property.getTypeInformation());
    }

    private Object getWriteValue(Object value, TypeInformation<?> typeInformation) {
        if (value == null) {
            return null;
        }
        if (this.getCustomConversions().isSimpleType(value.getClass())) {
            return this.getPotentiallyConvertedSimpleValue(value, typeInformation.getType());
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass())) {
            return this.getConversionService().convert(value, this.getCustomConversions().getCustomWriteTarget(value.getClass()));
        }
        ClassTypeInformation type = typeInformation != null ? typeInformation : ClassTypeInformation.from(value.getClass());
        TypeInformation actualType = type.getActualType();
        if (value instanceof Collection) {
            Collection original = (Collection)value;
            Collection converted = CollectionFactory.createCollection(this.getCollectionType((TypeInformation<?>)type), (int)original.size());
            for (Object element : original) {
                converted.add(this.convertToCassandraColumn(element, actualType));
            }
            return converted;
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(actualType.getType());
        if (persistentEntity != null && persistentEntity.isUserDefinedType()) {
            UDTValue udtValue = persistentEntity.getUserType().newValue();
            this.write(value, udtValue, persistentEntity);
            return udtValue;
        }
        return value;
    }

    private Object getPotentiallyConvertedSimpleValue(Object value, Class<?> requestedTargetType) {
        if (value == null) {
            return null;
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass(), requestedTargetType)) {
            return this.getConversionService().convert(value, this.getCustomConversions().getCustomWriteTarget(value.getClass(), requestedTargetType));
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            if (requestedTargetType != null && !requestedTargetType.isEnum() && this.getConversionService().canConvert(value.getClass(), requestedTargetType)) {
                return this.getConversionService().convert(value, requestedTargetType);
            }
            return ((Enum)value).name();
        }
        return value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null || target.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    private Class<?> getCollectionType(TypeInformation<?> type) {
        if (type.getType().isInterface()) {
            return type.getType();
        }
        if (ClassTypeInformation.LIST.isAssignableFrom(type)) {
            return ClassTypeInformation.LIST.getType();
        }
        if (ClassTypeInformation.SET.isAssignableFrom(type)) {
            return ClassTypeInformation.SET.getType();
        }
        if (!type.isCollectionLike()) {
            return ClassTypeInformation.LIST.getType();
        }
        return type.getType();
    }

    private Object getReadValue(CassandraValueProvider row, CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentEntity keyEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(property);
            return this.instantiatePrimaryKey(keyEntity, property, row);
        }
        Object obj = row.getPropertyValue(property);
        if (obj != null && this.conversions.hasCustomWriteTarget(property.getActualType()) && property.isCollectionLike() && Collection.class.isAssignableFrom(property.getType()) && obj instanceof Collection) {
            Collection original = (Collection)obj;
            Collection converted = CollectionFactory.createCollection((Class)property.getType(), (int)original.size());
            for (Object element : original) {
                converted.add(this.getConversionService().convert(element, property.getActualType()));
            }
            return converted;
        }
        if (property.isCollectionLike() && obj instanceof Collection) {
            return this.readCollectionOrArray(property.getTypeInformation(), (Collection)obj);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(property.getActualType());
        if (persistentEntity != null && persistentEntity.isUserDefinedType() && obj instanceof UDTValue) {
            return this.readEntityFromUdt(persistentEntity, (UDTValue)obj);
        }
        return this.getPotentiallyConvertedSimpleRead(obj, property.getType());
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, Collection<?> sourceValue) {
        ArrayList<Object> items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class<List> collectionType = targetType.getType();
        TypeInformation componentType = targetType.getComponentType();
        Class rawComponentType = componentType == null ? null : componentType.getType();
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        Collection<Object> collection = items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, (Class)rawComponentType, (int)sourceValue.size());
        if (sourceValue.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, collectionType);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(componentType);
        if (persistentEntity != null && persistentEntity.isUserDefinedType()) {
            for (Object udtValue : sourceValue) {
                items.add(this.readEntityFromUdt(persistentEntity, (UDTValue)udtValue));
            }
        } else {
            for (Object item : sourceValue) {
                items.add(this.getPotentiallyConvertedSimpleRead(item, rawComponentType));
            }
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return CodecRegistry.DEFAULT_INSTANCE.codecFor(this.mappingContext.getDataType(property));
    }

    class MappingAndConvertingValueProvider
    implements CassandraValueProvider {
        private final CassandraValueProvider parent;

        @Override
        public boolean hasProperty(CassandraPersistentProperty property) {
            return this.parent.hasProperty(property);
        }

        public Object getPropertyValue(CassandraPersistentProperty property) {
            return MappingCassandraConverter.this.getReadValue(this.parent, property);
        }

        public MappingAndConvertingValueProvider(CassandraValueProvider parent) {
            this.parent = parent;
        }
    }
}

