/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Row;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.springframework.cassandra.core.converter.RowToListConverter;
import org.springframework.cassandra.core.converter.RowToMapConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

abstract class CassandraConverters {
    private CassandraConverters() {
    }

    public static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)RowToCassandraLocalDateConverter.INSTANCE);
        converters.add((Object)RowToBooleanConverter.INSTANCE);
        converters.add((Object)RowToDateConverter.INSTANCE);
        converters.add((Object)RowToInetAddressConverter.INSTANCE);
        converters.add(RowToListConverter.INSTANCE);
        converters.add(RowToMapConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.INSTANCE);
        converters.add((Object)RowToStringConverter.INSTANCE);
        converters.add((Object)RowToUuidConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum RowToCassandraLocalDateConverter implements Converter<Row, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Row row) {
            return row.getDate(0);
        }
    }

    @ReadingConverter
    public static enum RowToUuidConverter implements Converter<Row, UUID>
    {
        INSTANCE;


        public UUID convert(Row row) {
            return row.getUUID(0);
        }
    }

    @ReadingConverter
    public static enum RowToStringConverter implements Converter<Row, String>
    {
        INSTANCE;


        public String convert(Row row) {
            return row.getString(0);
        }
    }

    @ReadingConverter
    public static enum RowToNumberConverterFactory implements ConverterFactory<Row, Number>
    {
        INSTANCE;


        public <T extends Number> Converter<Row, T> getConverter(Class<T> targetType) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            return new RowToNumber<T>(targetType);
        }

        private static final class RowToNumber<T extends Number>
        implements Converter<Row, T> {
            private final Class<T> targetType;

            public RowToNumber(Class<T> targetType) {
                this.targetType = targetType;
            }

            public T convert(Row source) {
                Object object = source.getObject(0);
                return (T)(object != null ? (Number)NumberUtils.convertNumberToTargetClass((Number)((Number)object), this.targetType) : (Number)null);
            }
        }
    }

    @ReadingConverter
    public static enum RowToInetAddressConverter implements Converter<Row, InetAddress>
    {
        INSTANCE;


        public InetAddress convert(Row row) {
            return row.getInet(0);
        }
    }

    @ReadingConverter
    public static enum RowToDateConverter implements Converter<Row, Date>
    {
        INSTANCE;


        public Date convert(Row row) {
            return row.getTimestamp(0);
        }
    }

    @ReadingConverter
    public static enum RowToBooleanConverter implements Converter<Row, Boolean>
    {
        INSTANCE;


        public Boolean convert(Row row) {
            return row.getBool(0);
        }
    }
}

