/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyMapping {
    private String columnName;
    private String forceQuote;
    private String propertyName;

    public PropertyMapping(String propertyName) {
        this.setPropertyName(propertyName);
    }

    public PropertyMapping(String propertyName, String columnName) {
        this(propertyName, columnName, "false");
    }

    public PropertyMapping(String propertyName, String columnName, String forceQuote) {
        this.setPropertyName(propertyName);
        this.setColumnName(columnName);
        this.setForceQuote(forceQuote);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        Assert.notNull((Object)columnName);
        this.columnName = columnName;
    }

    public String getForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(String forceQuote) {
        this.forceQuote = forceQuote;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        Assert.notNull((Object)propertyName);
        this.propertyName = propertyName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping that = (PropertyMapping)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getPropertyName(), (Object)that.getPropertyName()) && ObjectUtils.nullSafeEquals((Object)this.getColumnName(), (Object)that.getColumnName()) && ObjectUtils.nullSafeEquals((Object)this.getForceQuote(), (Object)that.getForceQuote());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getPropertyName());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getColumnName());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getForceQuote());
        return hashValue;
    }

    public String toString() {
        return String.format("{ @type = %1$s, propertyName = %2$s, columnName = %3$s, forceQuote = %4$s }", this.getClass().getName(), this.getPropertyName(), this.getColumnName(), this.getForceQuote());
    }
}

