/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.util.Collection;
import org.springframework.cassandra.config.CassandraCqlSessionFactoryBean;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;

public class CassandraSessionFactoryBean
extends CassandraCqlSessionFactoryBean {
    protected static final boolean DEFAULT_CREATE_IF_NOT_EXISTS = false;
    protected static final boolean DEFAULT_DROP_TABLES = false;
    protected static final boolean DEFAULT_DROP_UNUSED_TABLES = false;
    private CassandraAdminOperations admin;
    private CassandraConverter converter;
    private SchemaAction schemaAction = SchemaAction.NONE;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"Converter was not properly initialized");
        this.admin = this.newCassandraAdminOperations(this.getObject(), this.converter);
        this.performSchemaAction();
    }

    CassandraAdminOperations newCassandraAdminOperations(Session session, CassandraConverter converter) {
        return new CassandraAdminTemplate(session, converter);
    }

    protected void performSchemaAction() {
        boolean dropTables = false;
        boolean dropUnused = false;
        boolean ifNotExists = false;
        switch (this.schemaAction) {
            case RECREATE_DROP_UNUSED: {
                dropUnused = true;
            }
            case RECREATE: {
                dropTables = true;
            }
            case CREATE_IF_NOT_EXISTS: {
                ifNotExists = SchemaAction.CREATE_IF_NOT_EXISTS.equals((Object)this.schemaAction);
            }
            case CREATE: {
                this.createTables(dropTables, dropUnused, ifNotExists);
            }
        }
    }

    protected void createTables(boolean dropTables, boolean dropUnused, boolean ifNotExists) {
        if (dropTables) {
            this.dropTables(dropUnused);
        }
        Collection<CassandraPersistentEntity<?>> entities = this.getConverter().getMappingContext().getNonPrimaryKeyEntities();
        for (CassandraPersistentEntity<?> entity : entities) {
            this.getCassandraAdminOperations().createTable(ifNotExists, entity.getTableName(), entity.getType(), null);
        }
    }

    protected void dropTables(boolean dropUnused) {
        String keyspaceName = this.getKeyspaceName();
        Metadata clusterMetadata = this.getSession().getCluster().getMetadata();
        KeyspaceMetadata keyspaceMetadata = clusterMetadata.getKeyspace(keyspaceName);
        keyspaceMetadata = keyspaceMetadata != null ? keyspaceMetadata : clusterMetadata.getKeyspace(keyspaceName.toLowerCase());
        Assert.state((keyspaceMetadata != null ? 1 : 0) != 0, (String)String.format("keyspace [%s] does not exist", keyspaceName));
        for (TableMetadata table : keyspaceMetadata.getTables()) {
            if (!dropUnused && !this.getMappingContext().usesTable(table)) continue;
            this.getCassandraAdminOperations().dropTable(CqlIdentifier.cqlId((CharSequence)table.getName()));
        }
    }

    protected CassandraAdminOperations getCassandraAdminOperations() {
        return this.admin;
    }

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
    }

    public CassandraConverter getConverter() {
        return this.converter;
    }

    protected CassandraMappingContext getMappingContext() {
        return this.getConverter().getMappingContext();
    }

    public void setSchemaAction(SchemaAction schemaAction) {
        Assert.notNull((Object)((Object)schemaAction), (String)"SchemaAction must not be null");
        this.schemaAction = schemaAction;
    }

    public SchemaAction getSchemaAction() {
        return this.schemaAction;
    }
}

