/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.support.BasicMapId;
import org.springframework.data.cassandra.repository.support.Signature;
import org.springframework.util.StringUtils;

class MapIdProxyDelegate
implements InvocationHandler {
    private static final Map<Signature, Signature> MAP_ID_SIGNATURES;
    private MapId delegate = new BasicMapId();
    private Class<?> idInterface;

    public MapIdProxyDelegate(Class<?> idInterface) {
        this.idInterface = idInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isSetter;
        if (this.isMapIdMethod(method)) {
            return method.invoke((Object)this.delegate, args);
        }
        if (args != null && args.length > 1) {
            throw new IllegalArgumentException(String.format("Method [%s] on interface [%s] must take zero or one argument", method, this.idInterface));
        }
        boolean bl = isSetter = args != null && args.length == 1;
        if (isSetter) {
            this.invokeSetter(method, args[0]);
            return Void.TYPE.equals(method.getReturnType()) ? null : proxy;
        }
        return this.invokeGetter(method);
    }

    public boolean isMapIdMethod(Method method) {
        return MAP_ID_SIGNATURES.containsKey(new Signature(method, true));
    }

    public Serializable invokeGetter(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            if (name.length() == 3) {
                throw new IllegalArgumentException(String.format("Method [%s] on interface [%s] must be of form '<PropertyType> get<PropertyName>()' or '<PropertyType> <propertyName>()'", name, this.idInterface));
            }
            name = StringUtils.uncapitalize((String)name.substring(3));
        }
        return (Serializable)this.delegate.get(name);
    }

    public void invokeSetter(Method method, Object value) {
        String name = method.getName();
        int minLength = 1;
        boolean isSet = name.startsWith("set");
        boolean isWith = name.startsWith("with");
        minLength += isSet ? 3 : (isWith ? 4 : 0);
        int length = name.length();
        if (isSet || isWith) {
            if (length < minLength) {
                throw new IllegalArgumentException(String.format("Method [%s] on interface [%s] must be of form '<IdType|void> set<PropertyName>(<PropertyType>)', '<IdType|void> with<PropertyName>(<PropertyType>)' or '<IdType|void> <propertyName>(<PropertyType>)'", name, this.idInterface));
            }
            name = StringUtils.uncapitalize((String)name.substring(minLength - 1));
        }
        if (value == null) {
            this.delegate.put(name, null);
            return;
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException(String.format("Given object [%s] must implement %s", value, Serializable.class.getName()));
        }
        this.delegate.put(name, (Serializable)value);
    }

    static {
        Method[] mapIdMethods = MapId.class.getMethods();
        MAP_ID_SIGNATURES = new HashMap<Signature, Signature>(mapIdMethods.length);
        for (Method m : mapIdMethods) {
            Signature s = new Signature(m, true);
            MAP_ID_SIGNATURES.put(s, s);
        }
    }
}

