/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.util.Collection;
import java.util.LinkedList;
import org.springframework.data.cassandra.repository.support.IdInterfaceException;

public class IdInterfaceExceptions
extends RuntimeException {
    Collection<IdInterfaceException> exceptions = new LinkedList<IdInterfaceException>();
    String idInterfaceName;

    public IdInterfaceExceptions(Class<?> idInterface) {
        this.idInterfaceName = idInterface.getClass().getName();
    }

    public void add(IdInterfaceException e) {
        this.exceptions.add(e);
    }

    public Collection<IdInterfaceException> getExceptions() {
        return this.exceptions;
    }

    public Collection<String> getMessages() {
        LinkedList<String> messages = new LinkedList<String>();
        for (IdInterfaceException e : this.exceptions) {
            messages.add(e.getMessage());
        }
        return messages;
    }

    public int getCount() {
        return this.exceptions.size();
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(this.idInterfaceName).append(":\n");
        for (IdInterfaceException e : this.exceptions) {
            builder.append(e.getMessage()).append("\n");
        }
        return builder.toString();
    }

    public String getIdInterfaceName() {
        return this.idInterfaceName;
    }
}

