/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.Session;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.util.Assert;

public class CassandraTemplateFactoryBean
implements FactoryBean<CassandraOperations>,
InitializingBean {
    protected Session session;
    protected CassandraConverter converter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.session);
        Assert.notNull((Object)this.converter);
    }

    public CassandraOperations getObject() throws Exception {
        return new CassandraTemplate(this.session, this.converter);
    }

    public Class<?> getObjectType() {
        return CassandraOperations.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session);
        this.session = session;
    }

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter);
        this.converter = converter;
    }
}

