/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.Row;
import org.springframework.data.cassandra.convert.CassandraRowValueProvider;
import org.springframework.data.cassandra.convert.ColumnReader;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.util.Assert;

public class BasicCassandraRowValueProvider
implements CassandraRowValueProvider {
    private final ColumnReader reader;
    private final SpELExpressionEvaluator evaluator;

    public BasicCassandraRowValueProvider(Row source, DefaultSpELExpressionEvaluator evaluator) {
        Assert.notNull((Object)source);
        Assert.notNull((Object)evaluator);
        this.reader = new ColumnReader(source);
        this.evaluator = evaluator;
    }

    public Object getPropertyValue(CassandraPersistentProperty property) {
        String expression = property.getSpelExpression();
        if (expression != null) {
            return this.evaluator.evaluate(expression);
        }
        return this.reader.get(property.getColumnName());
    }

    @Override
    public Row getRow() {
        return this.reader.getRow();
    }
}

