/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;

public class MappingCassandraEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements CassandraEntityInformation<T, ID> {
    private final CassandraPersistentEntity<T> entityMetadata;
    private CassandraConverter converter;

    public MappingCassandraEntityInformation(CassandraPersistentEntity<T> entity, CassandraConverter converter) {
        super(entity.getType());
        this.entityMetadata = entity;
        this.converter = converter;
    }

    public ID getId(T entity) {
        Assert.notNull(entity);
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)this.entityMetadata.getIdProperty();
        if (idProperty != null) {
            return (ID)((Serializable)BeanWrapper.create(entity, null).getProperty((PersistentProperty)idProperty));
        }
        return (ID)((Serializable)this.converter.getId(entity, this.entityMetadata));
    }

    public Class<ID> getIdType() {
        return this.entityMetadata.getIdProperty() == null ? MapId.class : ((CassandraPersistentProperty)this.entityMetadata.getIdProperty()).getType();
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.entityMetadata.getTableName();
    }
}

