/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import java.util.List;
import org.springframework.cassandra.core.cql.CqlIdentifier;

public class ColumnReader {
    protected Row row;
    protected ColumnDefinitions columns;

    public ColumnReader(Row row) {
        this.row = row;
        this.columns = row.getColumnDefinitions();
    }

    public Object get(CqlIdentifier name) {
        return this.get(name.toCql());
    }

    public Object get(String name) {
        return this.get(this.columns.getIndexOf(name));
    }

    public Object get(int i) {
        if (this.row.isNull(i)) {
            return null;
        }
        DataType type = this.columns.getType(i);
        if (type.isCollection()) {
            List collectionTypes = type.getTypeArguments();
            if (collectionTypes.size() == 2) {
                return this.row.getMap(i, ((DataType)collectionTypes.get(0)).asJavaClass(), ((DataType)collectionTypes.get(1)).asJavaClass());
            }
            if (type.equals((Object)DataType.list((DataType)((DataType)collectionTypes.get(0))))) {
                return this.row.getList(i, ((DataType)collectionTypes.get(0)).asJavaClass());
            }
            if (type.equals((Object)DataType.set((DataType)((DataType)collectionTypes.get(0))))) {
                return this.row.getSet(i, ((DataType)collectionTypes.get(0)).asJavaClass());
            }
            throw new IllegalStateException("Unknown Collection type encountered.  Valid collections are Set, List and Map.");
        }
        if (type.equals((Object)DataType.text()) || type.equals((Object)DataType.ascii()) || type.equals((Object)DataType.varchar())) {
            return this.row.getString(i);
        }
        if (type.equals((Object)DataType.cint()) || type.equals((Object)DataType.varint())) {
            return new Integer(this.row.getInt(i));
        }
        if (type.equals((Object)DataType.cdouble())) {
            return new Double(this.row.getDouble(i));
        }
        if (type.equals((Object)DataType.bigint()) || type.equals((Object)DataType.counter())) {
            return new Long(this.row.getLong(i));
        }
        if (type.equals((Object)DataType.cfloat())) {
            return new Float(this.row.getFloat(i));
        }
        if (type.equals((Object)DataType.decimal())) {
            return this.row.getDecimal(i);
        }
        if (type.equals((Object)DataType.cboolean())) {
            return new Boolean(this.row.getBool(i));
        }
        if (type.equals((Object)DataType.timestamp())) {
            return this.row.getDate(i);
        }
        if (type.equals((Object)DataType.blob())) {
            return this.row.getBytes(i);
        }
        if (type.equals((Object)DataType.inet())) {
            return this.row.getInet(i);
        }
        if (type.equals((Object)DataType.uuid()) || type.equals((Object)DataType.timeuuid())) {
            return this.row.getUUID(i);
        }
        return this.row.getBytesUnsafe(i);
    }

    public Row getRow() {
        return this.row;
    }

    public <T> T get(CqlIdentifier name, Class<T> requestedType) {
        return this.get(this.columns.getIndexOf(name.toCql()), requestedType);
    }

    public <T> T get(String name, Class<T> requestedType) {
        return this.get(this.columns.getIndexOf(name), requestedType);
    }

    public <T> T get(int i, Class<T> requestedType) {
        Object o = this.get(i);
        if (o == null) {
            return null;
        }
        return (T)o;
    }
}

