/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DependenciesPassedCondition
extends SpringBootCondition {
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);
    private static final String ZOOKEEPER_DEPENDENCIES_PROP = "spring.cloud.zookeeper.dependencies";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map subProperties = (Map)Binder.get((Environment)context.getEnvironment()).bind(ZOOKEEPER_DEPENDENCIES_PROP, STRING_STRING_MAP).orElseGet(Collections::emptyMap);
        if (!subProperties.isEmpty()) {
            return ConditionOutcome.match((String)"Dependencies are defined in configuration");
        }
        Boolean dependenciesEnabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.zookeeper.dependency.enabled", Boolean.class, (Object)false);
        if (dependenciesEnabled.booleanValue()) {
            return ConditionOutcome.match((String)"Dependencies are not defined in configuration, but switch is turned on");
        }
        return ConditionOutcome.noMatch((String)"No dependencies have been passed for the service");
    }
}

