/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.reactive;

import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.reactive.ZookeeperReactiveDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnReactiveDiscoveryEnabled
@ConditionalOnZookeeperDiscoveryEnabled
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class, ZookeeperAutoConfiguration.class})
@AutoConfigureBefore(value={ReactiveCommonsClientAutoConfiguration.class})
public class ZookeeperReactiveDiscoveryClientConfiguration {
    @Autowired(required=false)
    private ZookeeperDependencies zookeeperDependencies;

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperReactiveDiscoveryClient zookeeperReactiveDiscoveryClient(ServiceDiscovery<ZookeeperInstance> serviceDiscovery, ZookeeperDiscoveryProperties zookeeperDiscoveryProperties) {
        return new ZookeeperReactiveDiscoveryClient(serviceDiscovery, this.zookeeperDependencies, zookeeperDiscoveryProperties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.health.contributor.ReactiveHealthIndicator"})
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    public ReactiveDiscoveryClientHealthIndicator zookeeperReactiveDiscoveryClientHealthIndicator(ZookeeperReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties) {
        return new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
    }
}

