/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.configclient;

import java.util.Collections;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.zookeeper.CuratorFactory;
import org.springframework.cloud.zookeeper.ZookeeperProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClient;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.support.DefaultServiceDiscoveryCustomizer;
import org.springframework.cloud.zookeeper.support.ServiceDiscoveryCustomizer;
import org.springframework.util.ClassUtils;

public class ZookeeperConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    private static ConfigServerConfigDataLocationResolver.PropertyResolver getPropertyResolver(BootstrapContext context) {
        return (ConfigServerConfigDataLocationResolver.PropertyResolver)context.getOrElseSupply(ConfigServerConfigDataLocationResolver.PropertyResolver.class, () -> new ConfigServerConfigDataLocationResolver.PropertyResolver((Binder)context.get(Binder.class), (BindHandler)context.getOrElse(BindHandler.class, null)));
    }

    public static boolean isEnabled(BootstrapContext bootstrapContext) {
        ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ZookeeperConfigServerBootstrapper.getPropertyResolver(bootstrapContext);
        return (Boolean)propertyResolver.get("spring.cloud.config.discovery.enabled", Boolean.class, (Object)false) != false && (Boolean)propertyResolver.get("spring.cloud.zookeeper.discovery.enabled", Boolean.class, (Object)true) != false && (Boolean)propertyResolver.get("spring.cloud.discovery.enabled", Boolean.class, (Object)true) != false;
    }

    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null) || ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.marker.Marker", null)) {
            return;
        }
        registry.registerIfAbsent(ZookeeperProperties.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return null;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ZookeeperConfigServerBootstrapper.getPropertyResolver(context);
            return (ZookeeperProperties)propertyResolver.resolveOrCreateConfigurationProperties("spring.cloud.zookeeper", ZookeeperProperties.class);
        });
        CuratorFactory.registerCurator((BootstrapRegistry)registry, null, (boolean)true, ZookeeperConfigServerBootstrapper::isEnabled);
        registry.registerIfAbsent(ZookeeperDiscoveryProperties.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return null;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ZookeeperConfigServerBootstrapper.getPropertyResolver(context);
            return (ZookeeperDiscoveryProperties)propertyResolver.resolveConfigurationProperties("spring.cloud.zookeeper.discovery", ZookeeperDiscoveryProperties.class, () -> new ZookeeperDiscoveryProperties(new InetUtils(new InetUtilsProperties())));
        });
        registry.registerIfAbsent(InstanceSerializer.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return null;
            }
            return new JsonInstanceSerializer(ZookeeperInstance.class);
        });
        registry.registerIfAbsent(ServiceDiscoveryCustomizer.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return null;
            }
            CuratorFramework curator = (CuratorFramework)context.get(CuratorFramework.class);
            ZookeeperDiscoveryProperties properties = (ZookeeperDiscoveryProperties)context.get(ZookeeperDiscoveryProperties.class);
            InstanceSerializer serializer = (InstanceSerializer)context.get(InstanceSerializer.class);
            return new DefaultServiceDiscoveryCustomizer(curator, properties, (InstanceSerializer<ZookeeperInstance>)serializer);
        });
        registry.registerIfAbsent(ServiceDiscovery.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return null;
            }
            ServiceDiscoveryCustomizer customizer = (ServiceDiscoveryCustomizer)context.get(ServiceDiscoveryCustomizer.class);
            return customizer.customize((ServiceDiscoveryBuilder<ZookeeperInstance>)ServiceDiscoveryBuilder.builder(ZookeeperInstance.class));
        });
        registry.registerIfAbsent(ZookeeperDiscoveryClient.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return null;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ZookeeperConfigServerBootstrapper.getPropertyResolver(context);
            ServiceDiscovery serviceDiscovery = (ServiceDiscovery)context.get(ServiceDiscovery.class);
            ZookeeperDependencies dependencies = (ZookeeperDependencies)propertyResolver.resolveConfigurationProperties("spring.cloud.zookeeper", ZookeeperDependencies.class, ZookeeperDependencies::new);
            ZookeeperDiscoveryProperties discoveryProperties = (ZookeeperDiscoveryProperties)context.get(ZookeeperDiscoveryProperties.class);
            return new ZookeeperDiscoveryClient((ServiceDiscovery<ZookeeperInstance>)serviceDiscovery, dependencies, discoveryProperties);
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!ZookeeperConfigServerBootstrapper.isEnabled(context)) {
                return id -> Collections.emptyList();
            }
            return ((ZookeeperDiscoveryClient)context.get(ZookeeperDiscoveryClient.class))::getInstances;
        });
        registry.addCloseListener(event -> {
            ZookeeperDiscoveryClient discoveryClient = (ZookeeperDiscoveryClient)event.getBootstrapContext().get(ZookeeperDiscoveryClient.class);
            if (discoveryClient != null) {
                event.getApplicationContext().getBeanFactory().registerSingleton("zookeeperServiceDiscovery", (Object)discoveryClient);
            }
        });
    }
}

