/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.PingUrl;
import com.netflix.loadbalancer.ServerList;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServerIntrospector;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServerList;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesNotPassed;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesPassed;
import org.springframework.cloud.zookeeper.discovery.dependency.DependenciesBasedLoadBalancer;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ZookeeperRibbonClientConfiguration {
    private static final Log log = LogFactory.getLog(ZookeeperRibbonClientConfiguration.class);
    protected static final String VALUE_NOT_SET = "__not__set__";
    protected static final String DEFAULT_NAMESPACE = "ribbon";
    @Value(value="${ribbon.client.name}")
    private String serviceId = "client";

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDependenciesPassed
    public ServerList<?> ribbonServerListFromDependencies(IClientConfig config, ZookeeperDependencies zookeeperDependencies, ServiceDiscovery<ZookeeperInstance> serviceDiscovery) {
        ZookeeperServerList serverList = new ZookeeperServerList(serviceDiscovery);
        serverList.initFromDependencies(config, zookeeperDependencies);
        log.debug((Object)String.format("Server list for Ribbon's dependencies based load balancing is [%s]", new Object[]{serverList}));
        return serverList;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDependenciesPassed
    @ConditionalOnProperty(value={"spring.cloud.zookeeper.dependency.ribbon.loadbalancer"}, matchIfMissing=true)
    public ILoadBalancer dependenciesBasedLoadBalancer(ZookeeperDependencies zookeeperDependencies, ServerList<?> serverList, IClientConfig config, IPing iPing) {
        return new DependenciesBasedLoadBalancer(zookeeperDependencies, serverList, config, iPing);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDependenciesPassed
    public IPing healthCheckingRule(ZookeeperDependencies zookeeperDependencies) {
        return new PingUrl(false, zookeeperDependencies.getDefaultHealthEndpoint());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDependenciesNotPassed
    public ServerList<?> ribbonServerList(IClientConfig config, ServiceDiscovery<ZookeeperInstance> serviceDiscovery) {
        ZookeeperServerList serverList = new ZookeeperServerList(serviceDiscovery);
        serverList.initWithNiwsConfig(config);
        log.debug((Object)String.format("Server list for Ribbon's non-dependency based load balancing is [%s]", new Object[]{serverList}));
        return serverList;
    }

    @Bean
    public ServerIntrospector serverIntrospector() {
        return new ZookeeperServerIntrospector();
    }

    @PostConstruct
    public void preprocess() {
        this.setProp(this.serviceId, CommonClientConfigKey.DeploymentContextBasedVipAddresses.key(), this.serviceId);
        this.setProp(this.serviceId, CommonClientConfigKey.EnableZoneAffinity.key(), "true");
    }

    protected void setProp(String serviceId, String suffix, String value) {
        String key = this.getKey(serviceId, suffix);
        DynamicStringProperty property = this.getProperty(key);
        if (property.get().equals(VALUE_NOT_SET)) {
            ConfigurationManager.getConfigInstance().setProperty(key, (Object)value);
        }
    }

    protected DynamicStringProperty getProperty(String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, VALUE_NOT_SET);
    }

    protected String getKey(String serviceId, String suffix) {
        return serviceId + "." + DEFAULT_NAMESPACE + "." + suffix;
    }
}

