/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.curator.x.discovery.UriSpec;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.springframework.beans.BeansException;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class ZookeeperServiceDiscovery
implements ZookeeperRegistration,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private CuratorFramework curator;
    private ZookeeperDiscoveryProperties properties;
    private InstanceSerializer<ZookeeperInstance> instanceSerializer;
    private AtomicBoolean built = new AtomicBoolean(false);
    private AtomicInteger port = new AtomicInteger();
    private AtomicReference<ServiceInstance<ZookeeperInstance>> serviceInstance = new AtomicReference();
    private AtomicReference<ServiceDiscovery<ZookeeperInstance>> serviceDiscovery = new AtomicReference();
    private String appName;
    private ApplicationContext context;
    private boolean register;

    public ZookeeperServiceDiscovery(CuratorFramework curator, ZookeeperDiscoveryProperties properties, InstanceSerializer<ZookeeperInstance> instanceSerializer) {
        this.curator = curator;
        this.properties = properties;
        this.instanceSerializer = instanceSerializer;
        this.register = this.properties.isRegister();
    }

    @Override
    public int getPort() {
        return this.port.get();
    }

    @Override
    public void setPort(int port) {
        this.port.set(port);
    }

    public void setRegister(boolean register) {
        this.register = register;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)this.context.getEnvironment());
        this.appName = resolver.getProperty("spring.application.name", "application");
    }

    public String getServiceId() {
        return this.appName;
    }

    public void build() {
        if (this.built.compareAndSet(false, true)) {
            if (this.port.get() <= 0 && this.register) {
                throw new IllegalStateException("Cannot create instance whose port is not greater than 0");
            }
            String host = this.properties.getInstanceHost();
            if (!StringUtils.hasText((String)host)) {
                throw new IllegalStateException("instanceHost must not be empty");
            }
            UriSpec uriSpec = new UriSpec(this.properties.getUriSpec());
            if (this.register) {
                this.configureServiceInstance(this.serviceInstance, this.appName, this.context, this.port, host, uriSpec);
            }
            if (this.serviceDiscovery.get() == null) {
                this.configureServiceDiscovery(this.serviceDiscovery, this.curator, this.properties, this.instanceSerializer, this.serviceInstance);
            }
        }
    }

    public void buildServiceDiscovery() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring service discovery for service instance [" + this.serviceInstance + "]"));
        }
        this.configureServiceDiscovery(this.serviceDiscovery, this.curator, this.properties, this.instanceSerializer, this.serviceInstance);
    }

    public void configureServiceInstance(AtomicReference<ServiceInstance<ZookeeperInstance>> serviceInstance, String appName, ApplicationContext context, AtomicInteger port, String host, UriSpec uriSpec) {
        try {
            ZookeeperInstance zookeeperInstance = new ZookeeperInstance(context.getId(), appName, this.properties.getMetadata());
            if (StringUtils.hasText((String)this.properties.getInitialStatus())) {
                zookeeperInstance.getMetadata().put("instance_status", this.properties.getInitialStatus());
            }
            ServiceInstanceBuilder builder = ServiceInstance.builder().name(appName).payload((Object)zookeeperInstance).port(port.get()).address(host).uriSpec(uriSpec);
            if (this.properties.getInstanceSslPort() != null) {
                builder.sslPort(this.properties.getInstanceSslPort().intValue());
            }
            serviceInstance.set((ServiceInstance<ZookeeperInstance>)builder.build());
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
    }

    public void configureServiceDiscovery(AtomicReference<ServiceDiscovery<ZookeeperInstance>> serviceDiscovery, CuratorFramework curator, ZookeeperDiscoveryProperties properties, InstanceSerializer<ZookeeperInstance> instanceSerializer, AtomicReference<ServiceInstance<ZookeeperInstance>> serviceInstance) {
        ServiceDiscoveryBuilder builder = ServiceDiscoveryBuilder.builder(ZookeeperInstance.class).client(curator).basePath(properties.getRoot()).serializer(instanceSerializer);
        if (serviceInstance != null) {
            builder.thisInstance(serviceInstance.get());
        }
        serviceDiscovery.set((ServiceDiscovery<ZookeeperInstance>)builder.build());
    }

    @Override
    public ServiceInstance<ZookeeperInstance> getServiceInstance() {
        this.build();
        return this.serviceInstance.get();
    }

    public AtomicReference<ServiceDiscovery<ZookeeperInstance>> getServiceDiscoveryRef() {
        return this.serviceDiscovery;
    }

    public AtomicReference<ServiceInstance<ZookeeperInstance>> getServiceInstanceRef() {
        return this.serviceInstance;
    }

    protected AtomicBoolean getBuilt() {
        return this.built;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }
}

