/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.watcher;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperServiceDiscovery;
import org.springframework.cloud.zookeeper.discovery.dependency.ConditionalOnDependenciesPassed;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependencies;
import org.springframework.cloud.zookeeper.discovery.dependency.ZookeeperDependenciesAutoConfiguration;
import org.springframework.cloud.zookeeper.discovery.watcher.DefaultDependencyWatcher;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyRegistrationHookProvider;
import org.springframework.cloud.zookeeper.discovery.watcher.DependencyWatcherListener;
import org.springframework.cloud.zookeeper.discovery.watcher.presence.DefaultDependencyPresenceOnStartupVerifier;
import org.springframework.cloud.zookeeper.discovery.watcher.presence.DependencyPresenceOnStartupVerifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnDependenciesPassed
@AutoConfigureAfter(value={ZookeeperDependenciesAutoConfiguration.class})
public class DependencyWatcherAutoConfiguration {
    @Autowired(required=false)
    private List<DependencyWatcherListener> dependencyWatcherListeners = new ArrayList<DependencyWatcherListener>();

    @Bean
    @ConditionalOnMissingBean
    public DependencyPresenceOnStartupVerifier dependencyPresenceOnStartupVerifier() {
        return new DefaultDependencyPresenceOnStartupVerifier();
    }

    @Bean(destroyMethod="clearDependencyRegistrationHooks")
    @ConditionalOnMissingBean
    public DependencyRegistrationHookProvider dependencyWatcher(ZookeeperServiceDiscovery serviceDiscovery, DependencyPresenceOnStartupVerifier dependencyPresenceOnStartupVerifier, ZookeeperDependencies zookeeperDependencies) {
        return new DefaultDependencyWatcher(serviceDiscovery, dependencyPresenceOnStartupVerifier, this.dependencyWatcherListeners, zookeeperDependencies);
    }
}

