/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.zookeeper.CuratorFactory;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigDataResource;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySources;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ZookeeperConfigDataLocationResolver
implements ConfigDataLocationResolver<ZookeeperConfigDataResource> {
    public static final String PREFIX = "zookeeper:";
    private final Log log;

    public ZookeeperConfigDataLocationResolver(Log log) {
        this.log = log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(PREFIX)) {
            return false;
        }
        boolean zkEnabled = (Boolean)context.getBinder().bind("spring.cloud.zookeeper.enabled", Boolean.class).orElse((Object)true);
        boolean zkConfigEnabled = (Boolean)context.getBinder().bind("spring.cloud.zookeeper.config.enabled", Boolean.class).orElse((Object)true);
        return zkConfigEnabled && zkEnabled;
    }

    public List<ZookeeperConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException {
        return Collections.emptyList();
    }

    public List<ZookeeperConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext context, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        UriComponents locationUri = this.parseLocation(location);
        CuratorFactory.registerCurator((BootstrapRegistry)context.getBootstrapContext(), (UriComponents)locationUri, (boolean)location.isOptional());
        ZookeeperConfigProperties properties = this.loadConfigProperties(context);
        context.getBootstrapContext().register(ZookeeperConfigProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)properties));
        ZookeeperPropertySources sources = new ZookeeperPropertySources(properties, this.log);
        List<ZookeeperPropertySources.Context> contexts = locationUri == null || CollectionUtils.isEmpty((Collection)locationUri.getPathSegments()) ? sources.generateAutomaticContexts(profiles.getAccepted(), false) : this.getCustomContexts(locationUri);
        context.getBootstrapContext().addCloseListener(event -> {
            HashMap source = new HashMap();
            source.put("spring.cloud.zookeeper.config.property-source-contexts", contexts.stream().map(ZookeeperPropertySources.Context::getPath).collect(Collectors.toList()));
            MapPropertySource propertySource = new MapPropertySource("zookeeperConfigData", source);
            event.getApplicationContext().getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
        });
        ArrayList<ZookeeperConfigDataResource> locations = new ArrayList<ZookeeperConfigDataResource>();
        contexts.forEach(propertySourceContext -> locations.add(new ZookeeperConfigDataResource(propertySourceContext.getPath(), location.isOptional(), propertySourceContext.getProfile())));
        return locations;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    protected List<ZookeeperPropertySources.Context> getCustomContexts(UriComponents uriComponents) {
        if (!StringUtils.hasLength((String)uriComponents.getPath())) {
            return Collections.emptyList();
        }
        return Arrays.stream(uriComponents.getPath().split(";")).map(ZookeeperPropertySources.Context::new).collect(Collectors.toList());
    }

    @Nullable
    protected UriComponents parseLocation(ConfigDataLocation location) {
        String originalUri = location.getNonPrefixedValue(PREFIX);
        if (!StringUtils.hasText((String)originalUri)) {
            return null;
        }
        String uri = !originalUri.startsWith("//") ? "zookeeper://" + originalUri : originalUri;
        return UriComponentsBuilder.fromUriString((String)uri).build();
    }

    protected ZookeeperConfigProperties loadConfigProperties(ConfigDataLocationResolverContext context) {
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        ZookeeperConfigProperties properties = (ZookeeperConfigProperties)binder.bind("spring.cloud.zookeeper.config", Bindable.of(ZookeeperConfigProperties.class), bindHandler).orElseGet(ZookeeperConfigProperties::new);
        if (!StringUtils.hasLength((String)properties.getName())) {
            properties.setName((String)binder.bind("spring.application.name", Bindable.of(String.class), bindHandler).orElse((Object)"application"));
        }
        return properties;
    }
}

