/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.Collections;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigDataResource;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;

public class ZookeeperConfigDataLoader
implements ConfigDataLoader<ZookeeperConfigDataResource> {
    public ConfigData load(ConfigDataLoaderContext context, ZookeeperConfigDataResource resource) {
        try {
            CuratorFramework curator = (CuratorFramework)context.getBootstrapContext().get(CuratorFramework.class);
            ZookeeperPropertySource propertySource = new ZookeeperPropertySource(resource.getContext(), curator);
            return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }
}

