/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.LifecycleAwareSessionManager;
import org.springframework.vault.authentication.LifecycleAwareSessionManagerSupport;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.authentication.event.AuthenticationEventMulticaster;
import org.springframework.vault.client.ClientHttpRequestFactoryFactory;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.RestTemplateCustomizer;
import org.springframework.vault.client.RestTemplateFactory;
import org.springframework.vault.client.RestTemplateRequestCustomizer;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.LeaseStrategy;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

final class VaultConfiguration {
    private final VaultProperties vaultProperties;

    VaultConfiguration(VaultProperties vaultProperties) {
        this.vaultProperties = vaultProperties;
    }

    static SslConfiguration createSslConfiguration(VaultProperties.Ssl ssl) {
        SslConfiguration.KeyStoreConfiguration keyStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
        SslConfiguration.KeyStoreConfiguration trustStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
        if (ssl.getKeyStore() != null) {
            keyStore = StringUtils.hasText((String)ssl.getKeyStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore(), (char[])ssl.getKeyStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore());
            if (StringUtils.hasText((String)ssl.getKeyStoreType())) {
                keyStore = keyStore.withStoreType(ssl.getKeyStoreType());
            }
        }
        if (ssl.getTrustStore() != null) {
            trustStore = StringUtils.hasText((String)ssl.getTrustStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore(), (char[])ssl.getTrustStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore());
            if (StringUtils.hasText((String)ssl.getTrustStoreType())) {
                trustStore = trustStore.withStoreType(ssl.getTrustStoreType());
            }
        }
        return new SslConfiguration(keyStore, trustStore, ssl.getEnabledProtocols(), ssl.getEnabledCipherSuites());
    }

    ClientHttpRequestFactory createClientHttpRequestFactory() {
        ClientOptions clientOptions = new ClientOptions(Duration.ofMillis(this.vaultProperties.getConnectionTimeout()), Duration.ofMillis(this.vaultProperties.getReadTimeout()));
        SslConfiguration sslConfiguration = VaultConfiguration.createSslConfiguration(this.vaultProperties.getSsl());
        return ClientHttpRequestFactoryFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration);
    }

    VaultEndpoint createVaultEndpoint() {
        if (StringUtils.hasText((String)this.vaultProperties.getUri())) {
            return VaultEndpoint.from((URI)URI.create(this.vaultProperties.getUri()));
        }
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(this.vaultProperties.getHost());
        vaultEndpoint.setPort(this.vaultProperties.getPort());
        vaultEndpoint.setScheme(this.vaultProperties.getScheme());
        return vaultEndpoint;
    }

    VaultEndpoint createVaultEndpoint(ServiceInstance server) {
        String fallbackScheme = StringUtils.hasText((String)this.vaultProperties.getUri()) ? URI.create(this.vaultProperties.getUri()).getScheme() : this.vaultProperties.getScheme();
        VaultEndpoint vaultEndpoint = VaultEndpoint.create((String)server.getHost(), (int)server.getPort());
        if (server.getMetadata().containsKey("scheme")) {
            vaultEndpoint.setScheme((String)server.getMetadata().get("scheme"));
        } else {
            vaultEndpoint.setScheme(server.isSecure() ? "https" : fallbackScheme);
        }
        return vaultEndpoint;
    }

    RestTemplateBuilder createRestTemplateBuilder(ClientHttpRequestFactory requestFactory, VaultEndpointProvider endpointProvider, List<RestTemplateCustomizer> customizers, List<RestTemplateRequestCustomizer<?>> requestCustomizers) {
        RestTemplateBuilder builder = RestTemplateBuilder.builder().requestFactory(requestFactory).endpointProvider(endpointProvider);
        customizers.forEach(xva$0 -> builder.customizers(new RestTemplateCustomizer[]{xva$0}));
        requestCustomizers.forEach(xva$0 -> builder.requestCustomizers(new RestTemplateRequestCustomizer[]{xva$0}));
        if (StringUtils.hasText((String)this.vaultProperties.getNamespace())) {
            builder.defaultHeader("X-Vault-Namespace", this.vaultProperties.getNamespace());
        }
        return builder;
    }

    SessionManager createSessionManager(ClientAuthentication clientAuthentication, Supplier<TaskScheduler> taskSchedulerSupplier, RestTemplateFactory restTemplateFactory) {
        VaultProperties.SessionLifecycle lifecycle = this.vaultProperties.getSession().getLifecycle();
        if (lifecycle.isEnabled()) {
            RestTemplate restTemplate = restTemplateFactory.create();
            LifecycleAwareSessionManagerSupport.FixedTimeoutRefreshTrigger trigger = new LifecycleAwareSessionManagerSupport.FixedTimeoutRefreshTrigger(lifecycle.getRefreshBeforeExpiry(), lifecycle.getExpiryThreshold());
            return new LifecycleAwareSessionManager(clientAuthentication, taskSchedulerSupplier.get(), (RestOperations)restTemplate, (LifecycleAwareSessionManagerSupport.RefreshTrigger)trigger);
        }
        return new SimpleSessionManager(clientAuthentication);
    }

    SecretLeaseContainer createSecretLeaseContainer(VaultOperations vaultOperations, Supplier<TaskScheduler> taskSchedulerSupplier, @Nullable SessionManager sessionManager) {
        VaultProperties.ConfigLifecycle lifecycle = this.vaultProperties.getConfig().getLifecycle();
        SecretLeaseContainer container = new SecretLeaseContainer(vaultOperations, taskSchedulerSupplier.get());
        if (sessionManager instanceof AuthenticationEventMulticaster) {
            AuthenticationEventMulticaster am = (AuthenticationEventMulticaster)sessionManager;
            am.addAuthenticationListener(container.getAuthenticationListener());
            am.addErrorListener(container.getAuthenticationErrorListener());
        }
        VaultConfiguration.customizeContainer(lifecycle, container);
        return container;
    }

    static ThreadPoolTaskScheduler createScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(2);
        threadPoolTaskScheduler.setDaemon(true);
        threadPoolTaskScheduler.setThreadNamePrefix("Spring-Cloud-Vault-");
        return threadPoolTaskScheduler;
    }

    static void customizeContainer(VaultProperties.ConfigLifecycle lifecycle, SecretLeaseContainer container) {
        if (lifecycle.isEnabled()) {
            if (lifecycle.getMinRenewal() != null) {
                container.setMinRenewal(lifecycle.getMinRenewal());
            }
            if (lifecycle.getExpiryThreshold() != null) {
                container.setExpiryThreshold(lifecycle.getExpiryThreshold());
            }
            if (lifecycle.getLeaseEndpoints() != null) {
                container.setLeaseEndpoints(lifecycle.getLeaseEndpoints());
            }
            if (lifecycle.getLeaseStrategy() != null) {
                switch (lifecycle.getLeaseStrategy()) {
                    case DropOnError: {
                        container.setLeaseStrategy(LeaseStrategy.dropOnError());
                        break;
                    }
                    case RetainOnError: {
                        container.setLeaseStrategy(LeaseStrategy.retainOnError());
                        break;
                    }
                    case RetainOnIoError: {
                        container.setLeaseStrategy(LeaseStrategy.retainOnIoError());
                    }
                }
            }
        }
    }
}

