/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.health.contributor.Health;
import org.springframework.util.StringUtils;
import org.springframework.vault.support.VaultHealth;

final class HealthBuilderDelegate {
    private HealthBuilderDelegate() {
    }

    static void contributeToHealth(VaultHealth healthResponse, Health.Builder builder) {
        if (!healthResponse.isInitialized()) {
            builder.down().withDetail("state", (Object)"Vault uninitialized");
        } else if (healthResponse.isSealed()) {
            builder.down().withDetail("state", (Object)"Vault sealed");
        } else if (healthResponse.isStandby()) {
            builder.up().withDetail("state", (Object)"Vault in standby");
        } else if (healthResponse.isPerformanceStandby()) {
            builder.up().withDetail("state", (Object)"Vault in performance standby");
        } else if (healthResponse.isRecoveryReplicationSecondary()) {
            builder.up().withDetail("state", (Object)"Vault in recovery replication secondary mode");
        } else {
            builder.up();
        }
        if (StringUtils.hasText((String)healthResponse.getVersion())) {
            builder.withDetail("version", (Object)healthResponse.getVersion());
        }
    }
}

