/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import com.google.auth.oauth2.GoogleCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.GcpIamCredentialsAuthentication;
import org.springframework.vault.authentication.GcpIamCredentialsAuthenticationOptions;
import org.springframework.vault.authentication.GoogleCredentialsSupplier;
import org.springframework.web.client.RestOperations;

final class GcpIamCredentialsAuthenticationFactory {
    private GcpIamCredentialsAuthenticationFactory() {
    }

    static ClientAuthentication create(VaultProperties vaultProperties, RestOperations restOperations) {
        VaultProperties.GcpIamProperties gcp = vaultProperties.getGcpIam();
        Assert.hasText((String)gcp.getRole(), (String)"Role (spring.cloud.vault.gcp-iam.role) must not be empty");
        GcpIamCredentialsAuthenticationOptions.GcpIamCredentialsAuthenticationOptionsBuilder builder = GcpIamCredentialsAuthenticationOptions.builder().path(gcp.getGcpPath()).role(gcp.getRole()).jwtValidity(gcp.getJwtValidity());
        if (StringUtils.hasText((String)gcp.getServiceAccountId())) {
            builder.serviceAccountId(gcp.getServiceAccountId());
        }
        GoogleCredentialsSupplier supplier = () -> GcpIamCredentialsAuthenticationFactory.getGoogleCredential(gcp);
        builder.credentials(supplier.get());
        GcpIamCredentialsAuthenticationOptions options = builder.build();
        return new GcpIamCredentialsAuthentication(options, restOperations);
    }

    private static GoogleCredentials getGoogleCredential(VaultProperties.GcpIamProperties gcp) throws IOException {
        VaultProperties.GcpCredentials credentialProperties = gcp.getCredentials();
        if (credentialProperties.getLocation() != null) {
            return GoogleCredentials.fromStream((InputStream)credentialProperties.getLocation().getInputStream());
        }
        if (StringUtils.hasText((String)credentialProperties.getEncodedKey())) {
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(credentialProperties.getEncodedKey())));
        }
        return GoogleCredentials.getApplicationDefault();
    }
}

