/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Collection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.vault.config.LeasingVaultPropertySourceLocator;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfigurationFactory;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultAutoConfiguration;
import org.springframework.cloud.vault.config.VaultConfigTemplate;
import org.springframework.cloud.vault.config.VaultConfiguration;
import org.springframework.cloud.vault.config.VaultConfigurer;
import org.springframework.cloud.vault.config.VaultKeyValueBackendProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySourceLocator;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.lease.SecretLeaseContainer;

@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VaultKeyValueBackendProperties.class})
@Order(value=0x7FFFFFF5)
@Deprecated
public class VaultBootstrapPropertySourceConfiguration
implements InitializingBean {
    private final VaultConfiguration configuration;
    private final ConfigurableApplicationContext applicationContext;
    @Nullable
    private Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors;
    @Nullable
    private Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories;

    public VaultBootstrapPropertySourceConfiguration(VaultProperties vaultProperties, ConfigurableApplicationContext applicationContext) {
        this.configuration = new VaultConfiguration(vaultProperties);
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.vaultSecretBackendDescriptors = this.applicationContext.getBeansOfType(VaultSecretBackendDescriptor.class).values();
        this.factories = this.applicationContext.getBeansOfType(SecretBackendMetadataFactory.class).values();
    }

    @Bean
    public PropertySourceLocator vaultPropertySourceLocator(VaultOperations operations, VaultProperties vaultProperties, VaultKeyValueBackendProperties kvBackendProperties, ObjectFactory<SecretLeaseContainer> secretLeaseContainerObjectFactory) {
        Assert.state((this.vaultSecretBackendDescriptors != null ? 1 : 0) != 0, (String)"VaultSecretBackendDescriptors must not be null");
        Assert.state((this.factories != null ? 1 : 0) != 0, (String)"SecretBackendMetadataFactories must not be null");
        VaultConfigTemplate vaultConfigTemplate = new VaultConfigTemplate(operations, vaultProperties);
        Collection<VaultConfigurer> vaultConfigurers = this.applicationContext.getBeansOfType(VaultConfigurer.class).values();
        PropertySourceLocatorConfigurationFactory factory = new PropertySourceLocatorConfigurationFactory(vaultConfigurers, this.vaultSecretBackendDescriptors, this.factories);
        PropertySourceLocatorConfiguration configuration = factory.getPropertySourceConfiguration(kvBackendProperties);
        VaultProperties.ConfigLifecycle lifecycle = vaultProperties.getConfig().getLifecycle();
        if (lifecycle.isEnabled()) {
            this.applicationContext.registerShutdownHook();
            SecretLeaseContainer secretLeaseContainer = (SecretLeaseContainer)secretLeaseContainerObjectFactory.getObject();
            secretLeaseContainer.start();
            return new LeasingVaultPropertySourceLocator(vaultProperties, configuration, secretLeaseContainer);
        }
        return new VaultPropertySourceLocator(vaultConfigTemplate, vaultProperties, configuration);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public SecretLeaseContainer secretLeaseContainer(VaultOperations vaultOperations, VaultAutoConfiguration.TaskSchedulerWrapper taskSchedulerWrapper) {
        return this.configuration.createSecretLeaseContainer(vaultOperations, taskSchedulerWrapper::getTaskScheduler);
    }
}

