/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.consul;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.vault.config.LeasingSecretBackendMetadata;
import org.springframework.cloud.vault.config.consul.VaultConsulProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.lease.event.SecretLeaseCreatedEvent;
import org.springframework.vault.core.util.PropertyTransformer;

class ConsulBackendMetadata
implements LeasingSecretBackendMetadata,
ApplicationEventPublisherAware {
    private final Log log = LogFactory.getLog(this.getClass());
    private final VaultConsulProperties properties;
    private final PropertyTransformer transformer;
    private ApplicationEventPublisher eventPublisher;

    ConsulBackendMetadata(VaultConsulProperties properties, PropertyTransformer transformer, ApplicationEventPublisher eventPublisher) {
        this.properties = properties;
        this.transformer = transformer;
        this.eventPublisher = eventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public String getName() {
        return String.format("%s with Role %s", this.properties.getBackend(), this.properties.getRole());
    }

    public String getPath() {
        return String.format("%s/creds/%s", this.properties.getBackend(), this.properties.getRole());
    }

    public Map<String, String> getVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("backend", this.properties.getBackend());
        variables.put("key", String.format("creds/%s", this.properties.getRole()));
        return variables;
    }

    public PropertyTransformer getPropertyTransformer() {
        return this.transformer;
    }

    public RequestedSecret.Mode getLeaseMode() {
        return RequestedSecret.Mode.ROTATE;
    }

    public void afterRegistration(RequestedSecret secret, SecretLeaseContainer container) {
        container.addLeaseListener(leaseEvent -> {
            if (leaseEvent.getSource() == secret && leaseEvent instanceof SecretLeaseCreatedEvent) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Publishing a RebindConsulEvent");
                }
                this.eventPublisher.publishEvent((ApplicationEvent)new RebindConsulEvent(this));
            }
        });
    }

    public static class RebindConsulEvent
    extends ApplicationEvent {
        RebindConsulEvent(Object source) {
            super(source);
        }
    }
}

