/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.aws;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.LeasingSecretBackendMetadata;
import org.springframework.cloud.vault.config.PropertyNameTransformer;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.aws.AwsCredentialType;
import org.springframework.cloud.vault.config.aws.VaultAwsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.util.PropertyTransformer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={VaultAwsProperties.class})
public class VaultConfigAwsBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AwsSecretBackendMetadataFactory awsSecretBackendMetadataFactory() {
        return new AwsSecretBackendMetadataFactory();
    }

    public static class AwsSecretBackendMetadataFactory
    implements SecretBackendMetadataFactory<VaultAwsProperties> {
        static SecretBackendMetadata forAws(VaultAwsProperties properties) {
            Assert.notNull((Object)properties, (String)"VaultAwsProperties must not be null");
            PropertyNameTransformer transformer = new PropertyNameTransformer();
            transformer.addKeyTransformation("access_key", properties.getAccessKeyProperty());
            transformer.addKeyTransformation("secret_key", properties.getSecretKeyProperty());
            if (properties.getCredentialType() == AwsCredentialType.ASSUMED_ROLE || properties.getCredentialType() == AwsCredentialType.FEDERATION_TOKEN) {
                transformer.addKeyTransformation("security_token", properties.getSessionTokenKeyProperty());
                return new AwsStsLeasingSecretBackendMetadata(properties, transformer);
            }
            return new AwsLeasingSecretBackendMetadata(properties, transformer);
        }

        public SecretBackendMetadata createMetadata(VaultAwsProperties backendDescriptor) {
            return AwsSecretBackendMetadataFactory.forAws(backendDescriptor);
        }

        public boolean supports(VaultSecretBackendDescriptor backendDescriptor) {
            return backendDescriptor instanceof VaultAwsProperties;
        }

        private static class AwsStsLeasingSecretBackendMetadata
        implements LeasingSecretBackendMetadata {
            private final VaultAwsProperties properties;
            private final PropertyNameTransformer transformer;

            AwsStsLeasingSecretBackendMetadata(VaultAwsProperties properties, PropertyNameTransformer transformer) {
                this.properties = properties;
                this.transformer = transformer;
            }

            public String getName() {
                return String.format("%s with Role %s", this.properties.getBackend(), this.properties.getRole());
            }

            public String getPath() {
                String defaultPath = "%s/sts/%s";
                StringJoiner joiner = new StringJoiner("&");
                if (!this.properties.getTtl().isZero()) {
                    joiner.add("ttl=" + this.properties.getTtl().toMillis() + "ms");
                }
                if (this.properties.getCredentialType() == AwsCredentialType.ASSUMED_ROLE && StringUtils.hasText((String)this.properties.getRoleArn())) {
                    joiner.add("role_arn=" + this.properties.getRoleArn());
                }
                String pathToUse = joiner.length() == 0 ? defaultPath : defaultPath + "?" + joiner;
                return String.format(pathToUse, this.properties.getBackend(), this.properties.getRole());
            }

            public PropertyTransformer getPropertyTransformer() {
                return this.transformer;
            }

            public Map<String, String> getVariables() {
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("backend", this.properties.getBackend());
                variables.put("key", String.format("sts/%s", this.properties.getRole()));
                return variables;
            }

            public RequestedSecret.Mode getLeaseMode() {
                return RequestedSecret.Mode.ROTATE;
            }
        }

        private static class AwsLeasingSecretBackendMetadata
        implements SecretBackendMetadata {
            private final VaultAwsProperties properties;
            private final PropertyNameTransformer transformer;

            AwsLeasingSecretBackendMetadata(VaultAwsProperties properties, PropertyNameTransformer transformer) {
                this.properties = properties;
                this.transformer = transformer;
            }

            public String getName() {
                return String.format("%s with Role %s", this.properties.getBackend(), this.properties.getRole());
            }

            public String getPath() {
                return String.format("%s/creds/%s", this.properties.getBackend(), this.properties.getRole());
            }

            public PropertyTransformer getPropertyTransformer() {
                return this.transformer;
            }

            public Map<String, String> getVariables() {
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("backend", this.properties.getBackend());
                variables.put("key", String.format("creds/%s", this.properties.getRole()));
                return variables;
            }
        }
    }
}

