/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.job.parameters.JobParameter;

public class JobParameterEvent {
    private Object parameter;
    private boolean identifying;

    public JobParameterEvent() {
    }

    public JobParameterEvent(JobParameter jobParameter) {
        this.parameter = jobParameter.value();
        this.identifying = jobParameter.identifying();
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public Object getValue() {
        if (this.parameter != null && this.parameter.getClass().isInstance(Date.class)) {
            return new Date(((Date)this.parameter).getTime());
        }
        return this.parameter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameterEvent)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JobParameterEvent rhs = (JobParameterEvent)obj;
        return Objects.equals(this.parameter, rhs.parameter);
    }

    public String toString() {
        return this.parameter == null ? null : this.parameter.toString();
    }

    public int hashCode() {
        int BASE_HASH = 7;
        int MULTIPLIER_HASH = 21;
        return 7 + 21 * this.parameter.hashCode();
    }
}

