/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.listener.ItemReadListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EventEmittingItemReadListener
implements ItemReadListener,
Ordered {
    private static final Log logger = LogFactory.getLog(EventEmittingItemReadListener.class);
    private int order = Integer.MAX_VALUE;
    private final MessagePublisher<String> messagePublisher;
    private TaskEventProperties properties;

    public EventEmittingItemReadListener(MessagePublisher messagePublisher, TaskEventProperties properties) {
        Assert.notNull((Object)messagePublisher, (String)"messagePublisher is required");
        Assert.notNull((Object)properties, (String)"properties is required");
        this.properties = properties;
        this.messagePublisher = messagePublisher;
    }

    public EventEmittingItemReadListener(MessagePublisher messagePublisher, int order, TaskEventProperties properties) {
        this(messagePublisher, properties);
        this.order = order;
    }

    public void beforeRead() {
    }

    public void afterRead(Object item) {
    }

    public void onReadError(Exception ex) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing onReadError: " + ex.getMessage()), (Throwable)ex);
        }
        this.messagePublisher.publishWithThrowableHeader(this.properties.getItemReadEventBindingName(), "Exception while item was being read", ex.getMessage());
    }

    public int getOrder() {
        return this.order;
    }
}

