/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagePublisher<P> {
    private final StreamBridge streamBridge;

    public MessagePublisher(StreamBridge streamBridge) {
        Assert.notNull((Object)streamBridge, (String)"streamBridge must not be null");
        this.streamBridge = streamBridge;
    }

    public final void publish(String bindingName, P payload) {
        if (payload instanceof Message) {
            this.publishMessage(bindingName, (Message)payload);
        } else {
            Message message = MessageBuilder.withPayload(payload).build();
            this.streamBridge.send(bindingName, (Object)message);
        }
    }

    private void publishMessage(String bindingName, Message<?> message) {
        this.streamBridge.send(bindingName, message);
    }

    public void publishWithThrowableHeader(String bindingName, P payload, String header) {
        Message message = MessageBuilder.withPayload(payload).setHeader("batch_exception", (Object)header).build();
        this.publishMessage(bindingName, message);
    }
}

