/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.reflection;

import java.lang.reflect.Type;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableSource;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class GenericsUtils {
    private GenericsUtils() {
    }

    public static Class<?> getParameterType(Class<?> evaluatedClass, Class<?> interfaceClass, int position) {
        Class<Object> bindableType = null;
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"'interfaceClass' must be an interface");
        if (!interfaceClass.isAssignableFrom(evaluatedClass)) {
            throw new IllegalStateException(String.valueOf(evaluatedClass) + " does not implement " + String.valueOf(interfaceClass));
        }
        ResolvableType currentType = ResolvableType.forType(evaluatedClass);
        while (!Object.class.equals((Object)currentType.getRawClass()) && bindableType == null) {
            ResolvableType[] interfaces = currentType.getInterfaces();
            ResolvableType resolvableType = null;
            for (ResolvableType interfaceType : interfaces) {
                if (!interfaceClass.equals(interfaceType.getRawClass())) continue;
                resolvableType = interfaceType;
                break;
            }
            if (resolvableType == null) {
                currentType = currentType.getSuperType();
                continue;
            }
            ResolvableType[] generics = resolvableType.getGenerics();
            ResolvableType generic = generics[position];
            Class<Object> resolvedParameter = generic.resolve();
            if (resolvedParameter != null) {
                bindableType = resolvedParameter;
                continue;
            }
            bindableType = Object.class;
        }
        if (bindableType == null) {
            throw new IllegalStateException("Cannot find parameter of " + evaluatedClass.getName() + " for " + String.valueOf(interfaceClass) + " at position " + position);
        }
        return bindableType;
    }

    public static boolean checkCompatiblePollableBinder(Binder binderInstance, Class<?> bindingTargetType) {
        Class[] binderInterfaces;
        for (Class intf : binderInterfaces = ClassUtils.getAllInterfaces((Object)binderInstance)) {
            Class[] targetInterfaces;
            Class<?> psType;
            if (!PollableConsumerBinder.class.isAssignableFrom(intf) || (psType = GenericsUtils.findPollableSourceType(targetInterfaces = ClassUtils.getAllInterfacesForClass(bindingTargetType))) == null) continue;
            return GenericsUtils.getParameterType(binderInstance.getClass(), intf, 0).isAssignableFrom(psType);
        }
        return false;
    }

    private static Class<?> findPollableSourceType(Class<?>[] targetInterfaces) {
        for (Class<?> targetIntf : targetInterfaces) {
            Type[] supers;
            if (!PollableSource.class.isAssignableFrom(targetIntf)) continue;
            for (Type type : supers = targetIntf.getGenericInterfaces()) {
                ResolvableType resolvableType = ResolvableType.forType((Type)type);
                if (!resolvableType.getRawClass().equals(PollableSource.class)) continue;
                return resolvableType.getGeneric(new int[]{0}).getRawClass();
            }
        }
        return null;
    }
}

