/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.cloud.stream.binding.SupportedBindableFeatures;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.integration.channel.FluxMessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class BindableFunctionProxyFactory
extends BindableProxyFactory
implements ApplicationContextAware {
    private final int inputCount;
    private final int outputCount;
    private final String functionDefinition;
    private final StreamFunctionProperties functionProperties;
    private final SupportedBindableFeatures supportedBindableFeatures;
    private final boolean functionExist;
    private GenericApplicationContext context;
    private static Map<String, String> channelNameToFunctions = new HashMap<String, String>();

    public BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties) {
        this(functionDefinition, inputCount, outputCount, functionProperties, new SupportedBindableFeatures(), true);
    }

    public BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties, boolean functionExist) {
        this(functionDefinition, inputCount, outputCount, functionProperties, new SupportedBindableFeatures(), functionExist);
    }

    BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties, SupportedBindableFeatures supportedBindableFeatures) {
        this(functionDefinition, inputCount, outputCount, functionProperties, supportedBindableFeatures, true);
    }

    BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties, SupportedBindableFeatures supportedBindableFeatures, boolean functionExist) {
        super(null);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.functionDefinition = functionDefinition;
        this.functionProperties = functionProperties;
        this.supportedBindableFeatures = supportedBindableFeatures;
        this.functionExist = functionExist;
    }

    public String toString() {
        return "Bindable: " + this.functionDefinition;
    }

    @Override
    public void afterPropertiesSet() {
        int i;
        this.populateBindingTargetFactories(this.beanFactory);
        Assert.notEmpty((Map)this.bindingTargetFactories, (String)"'bindingTargetFactories' cannot be empty");
        if (this.inputCount > 0) {
            for (i = 0; i < this.inputCount; ++i) {
                this.createInput(this.buildInputNameForIndex(i));
            }
        }
        if (this.outputCount > 0) {
            for (i = 0; i < this.outputCount; ++i) {
                this.createOutput(this.buildOutputNameForIndex(i));
            }
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.type;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getFunctionDefinition() {
        return this.isFunctionExist() ? this.functionDefinition : null;
    }

    protected String getInputName(int index) {
        return CollectionUtils.isEmpty(this.getInputs()) ? null : this.getInputs().toArray(new String[0])[index];
    }

    protected String getOutputName(int index) {
        String outputName = null;
        if (this.outputCount > 0) {
            outputName = CollectionUtils.isEmpty(this.getOutputs()) ? null : this.getOutputs().toArray(new String[0])[index];
        }
        return outputName;
    }

    protected boolean isMultiple() {
        return this.inputCount > 1 || this.outputCount > 1;
    }

    private String buildInputNameForIndex(int index) {
        if (!this.isFunctionExist()) {
            return this.functionDefinition;
        }
        return this.functionDefinition.replace(",", "|").replace("|", "") + "-" + "in" + "-" + index;
    }

    private String buildOutputNameForIndex(int index) {
        if (!this.isFunctionExist()) {
            return this.functionDefinition;
        }
        return this.functionDefinition.replace(",", "|").replace("|", "") + "-" + "out" + "-" + index;
    }

    private void createInput(String name) {
        if (this.functionProperties.getBindings().containsKey(name)) {
            name = this.functionProperties.getBindings().get(name);
        }
        this.updateChannelNameToFunctionName(name);
        if (this.supportedBindableFeatures.isPollable()) {
            PollableMessageSource pollableSource = (PollableMessageSource)this.getBindingTargetFactory(PollableMessageSource.class).createInput(name);
            if (this.context != null && !this.context.containsBean(name)) {
                this.context.registerBean(name, PollableMessageSource.class, () -> pollableSource, new BeanDefinitionCustomizer[0]);
            }
            this.inputHolders.put(name, new BoundTargetHolder(pollableSource, true));
        } else if (this.supportedBindableFeatures.isReactive()) {
            this.inputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(FluxMessageChannel.class).createInput(name), true));
        } else {
            this.inputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(SubscribableChannel.class).createInput(name), true));
        }
    }

    private void updateChannelNameToFunctionName(String name) {
        channelNameToFunctions.put(name, this.functionDefinition);
    }

    private void createOutput(String name) {
        if (this.functionProperties.getBindings().containsKey(name)) {
            name = this.functionProperties.getBindings().get(name);
        }
        this.updateChannelNameToFunctionName(name);
        if (this.supportedBindableFeatures.isReactive()) {
            this.outputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(FluxMessageChannel.class).createOutput(name), true));
        } else {
            this.outputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(SubscribableChannel.class).createOutput(name), true));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (GenericApplicationContext)applicationContext;
        this.setBeanFactory((BeanFactory)this.context.getBeanFactory());
    }

    public boolean isFunctionExist() {
        return this.functionExist;
    }

    public static Map<String, String> getChannelNameToFunctions() {
        return channelNameToFunctions;
    }
}

