/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;

public final class DynamicDestinationsBindable
implements Bindable {
    private final Map<String, Binding<?>> outputBindings = new HashMap();
    private static final ReentrantLock outputBindingsLock = new ReentrantLock();

    public void addOutputBinding(String name, Binding<?> binding) {
        try {
            outputBindingsLock.lock();
            this.outputBindings.put(name, binding);
        }
        finally {
            outputBindingsLock.unlock();
        }
    }

    @Override
    public Set<String> getOutputs() {
        try {
            outputBindingsLock.lock();
            Set<String> set = Collections.unmodifiableSet(this.outputBindings.keySet());
            return set;
        }
        finally {
            outputBindingsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindOutputs(BindingService adapter) {
        try {
            outputBindingsLock.lock();
            for (Map.Entry<String, Binding<?>> entry : this.outputBindings.entrySet()) {
                entry.getValue().unbind();
            }
            this.outputBindings.clear();
        }
        finally {
            outputBindingsLock.unlock();
        }
    }
}

