/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Duration;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.expression.Expression;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.ser.std.StdSerializer;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ProducerProperties {
    private String bindingName;
    private boolean autoStartup = true;
    @JsonSerialize(using=ExpressionSerializer.class)
    private Expression partitionKeyExpression;
    private String partitionKeyExtractorName;
    private String partitionSelectorName;
    @JsonSerialize(using=ExpressionSerializer.class)
    private Expression partitionSelectorExpression;
    private int partitionCount = 1;
    private String[] requiredGroups = new String[0];
    private HeaderMode headerMode;
    private boolean useNativeEncoding = false;
    private boolean errorChannelEnabled = false;
    private PollerProperties poller;
    private boolean dynamicPartitionUpdatesEnabled = false;

    public String getBindingName() {
        return this.bindingName;
    }

    public void populateBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public Expression getPartitionKeyExpression() {
        return this.partitionKeyExpression;
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public boolean isPartitioned() {
        return this.partitionKeyExpression != null || this.partitionKeyExtractorName != null;
    }

    public Expression getPartitionSelectorExpression() {
        return this.partitionSelectorExpression;
    }

    public void setPartitionSelectorExpression(Expression partitionSelectorExpression) {
        this.partitionSelectorExpression = partitionSelectorExpression;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public String[] getRequiredGroups() {
        return this.requiredGroups;
    }

    public void setRequiredGroups(String ... requiredGroups) {
        this.requiredGroups = requiredGroups;
    }

    public boolean isValidPartitionKeyProperty() {
        return this.partitionKeyExpression == null;
    }

    public boolean isValidPartitionSelectorProperty() {
        return this.partitionSelectorExpression == null;
    }

    public HeaderMode getHeaderMode() {
        return this.headerMode;
    }

    public void setHeaderMode(HeaderMode headerMode) {
        this.headerMode = headerMode;
    }

    public boolean isUseNativeEncoding() {
        return this.useNativeEncoding;
    }

    public void setUseNativeEncoding(boolean useNativeEncoding) {
        this.useNativeEncoding = useNativeEncoding;
    }

    public boolean isErrorChannelEnabled() {
        return this.errorChannelEnabled;
    }

    public void setErrorChannelEnabled(boolean errorChannelEnabled) {
        this.errorChannelEnabled = errorChannelEnabled;
    }

    public String getPartitionKeyExtractorName() {
        return this.partitionKeyExtractorName;
    }

    public void setPartitionKeyExtractorName(String partitionKeyExtractorName) {
        this.partitionKeyExtractorName = partitionKeyExtractorName;
    }

    public String getPartitionSelectorName() {
        return this.partitionSelectorName;
    }

    public void setPartitionSelectorName(String partitionSelectorName) {
        this.partitionSelectorName = partitionSelectorName;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public PollerProperties getPoller() {
        return this.poller;
    }

    public void setPoller(PollerProperties poller) {
        this.poller = poller;
    }

    public boolean isDynamicPartitionUpdatesEnabled() {
        return this.dynamicPartitionUpdatesEnabled;
    }

    public void setDynamicPartitionUpdatesEnabled(boolean enabled) {
        this.dynamicPartitionUpdatesEnabled = enabled;
    }

    public static class PollerProperties {
        private Duration fixedDelay = Duration.ofMillis(1000L);
        private long maxMessagesPerPoll = 1L;
        private String cron;
        private Duration initialDelay = Duration.ofMillis(0L);

        public long getMaxMessagesPerPoll() {
            return this.maxMessagesPerPoll;
        }

        public void setMaxMessagesPerPoll(long maxMessagesPerPoll) {
            this.maxMessagesPerPoll = maxMessagesPerPoll;
        }

        public String getCron() {
            return this.cron;
        }

        public void setCron(String cron) {
            this.cron = cron;
        }

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public Duration getFixedDelay() {
            return this.fixedDelay;
        }

        public void setFixedDelay(Duration fixedDelay) {
            this.fixedDelay = fixedDelay;
        }
    }

    public static class ExpressionSerializer
    extends StdSerializer<Expression> {
        public ExpressionSerializer() {
            super(Expression.class);
        }

        public ExpressionSerializer(Class<Expression> t) {
            super(t);
        }

        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializationContext provider) throws JacksonException {
            if (expression != null) {
                jsonGenerator.writeString(expression.getExpressionString());
            }
        }
    }
}

