/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.io.Closeable;
import java.io.IOException;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;

public class MessageChannelStreamListenerResultAdapter
implements StreamListenerResultAdapter<MessageChannel, MessageChannel> {
    @Override
    public boolean supports(Class<?> resultType, Class<?> bindingTarget) {
        return MessageChannel.class.isAssignableFrom(resultType) && MessageChannel.class.isAssignableFrom(bindingTarget);
    }

    @Override
    public Closeable adapt(MessageChannel streamListenerResult, MessageChannel bindingTarget) {
        BridgeHandler handler = new BridgeHandler();
        handler.setOutputChannel(bindingTarget);
        handler.afterPropertiesSet();
        ((SubscribableChannel)streamListenerResult).subscribe((MessageHandler)handler);
        return new NoOpCloseeable();
    }

    private static final class NoOpCloseeable
    implements Closeable {
        private NoOpCloseeable() {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

