/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.List;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binding.MessageChannelAndSourceConfigurer;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.messaging.MessageChannel;

public class CompositeMessageChannelConfigurer
implements MessageChannelAndSourceConfigurer {
    private final List<MessageChannelConfigurer> messageChannelConfigurers;

    public CompositeMessageChannelConfigurer(List<MessageChannelConfigurer> messageChannelConfigurers) {
        this.messageChannelConfigurers = messageChannelConfigurers;
    }

    @Override
    public void configureInputChannel(MessageChannel messageChannel, String channelName) {
        for (MessageChannelConfigurer messageChannelConfigurer : this.messageChannelConfigurers) {
            messageChannelConfigurer.configureInputChannel(messageChannel, channelName);
        }
    }

    @Override
    public void configureOutputChannel(MessageChannel messageChannel, String channelName) {
        for (MessageChannelConfigurer messageChannelConfigurer : this.messageChannelConfigurers) {
            messageChannelConfigurer.configureOutputChannel(messageChannel, channelName);
        }
    }

    @Override
    public void configurePolledMessageSource(PollableMessageSource binding, String name) {
        this.messageChannelConfigurers.forEach(cconfigurer -> {
            if (cconfigurer instanceof MessageChannelAndSourceConfigurer) {
                ((MessageChannelAndSourceConfigurer)cconfigurer).configurePolledMessageSource(binding, name);
            }
        });
    }
}

