/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamMessageConverter;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.integration.support.converter.ConfigurableCompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.CollectionUtils;

@Configuration
@Role(value=2)
public class ContentTypeConfiguration {
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    @StreamMessageConverter
    private List<MessageConverter> customMessageConverters;

    @Bean
    public CompositeMessageConverterFactory compositeMessageConverterFactory() {
        ArrayList<MessageConverter> messageConverters = new ArrayList<MessageConverter>();
        if (!CollectionUtils.isEmpty(this.customMessageConverters)) {
            messageConverters.addAll(Collections.unmodifiableCollection(this.customMessageConverters));
        }
        return new CompositeMessageConverterFactory(messageConverters, this.objectMapper);
    }

    @Bean(name={"integrationArgumentResolverMessageConverter"})
    public ConfigurableCompositeMessageConverter configurableCompositeMessageConverter(CompositeMessageConverterFactory factory) {
        return new ConfigurableCompositeMessageConverter((Collection)factory.getMessageConverterForAllRegistered().getConverters());
    }
}

