/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.EnvironmentEntryInitializingTreeMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cloud.stream")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class BindingServiceProperties
implements ApplicationContextAware,
InitializingBean {
    private static final int DEFAULT_BINDING_RETRY_INTERVAL = 30;
    @Value(value="${INSTANCE_INDEX:${CF_INSTANCE_INDEX:0}}")
    private int instanceIndex;
    private int instanceCount = 1;
    private Map<String, BindingProperties> bindings = new TreeMap<String, BindingProperties>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, BinderProperties> binders = new HashMap<String, BinderProperties>();
    private String defaultBinder;
    private String[] dynamicDestinations = new String[0];
    private int bindingRetryInterval = 30;
    private ConfigurableApplicationContext applicationContext;
    private ConversionService conversionService;

    public Map<String, BindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, BindingProperties> bindings) {
        this.bindings = bindings;
    }

    public Map<String, BinderProperties> getBinders() {
        return this.binders;
    }

    public void setBinders(Map<String, BinderProperties> binders) {
        this.binders = binders;
    }

    public String getDefaultBinder() {
        return this.defaultBinder;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(int instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    public String[] getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    public void setDynamicDestinations(String[] dynamicDestinations) {
        this.dynamicDestinations = dynamicDestinations;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        GenericConversionService cs = (GenericConversionService)IntegrationUtils.getConversionService((BeanFactory)this.applicationContext.getBeanFactory());
        if (this.applicationContext.containsBean("spelConverter")) {
            Converter converter = (Converter)this.applicationContext.getBean("spelConverter");
            cs.addConverter(converter);
        }
        if (this.applicationContext.getEnvironment() instanceof ConfigurableEnvironment) {
            TreeMap<String, BindingProperties> delegate = new TreeMap<String, BindingProperties>(String.CASE_INSENSITIVE_ORDER);
            delegate.putAll(this.bindings);
            this.bindings = new EnvironmentEntryInitializingTreeMap<BindingProperties>(this.applicationContext.getEnvironment(), BindingProperties.class, "spring.cloud.stream.default", delegate, IntegrationUtils.getConversionService((BeanFactory)this.applicationContext.getBeanFactory()));
        }
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.conversionService == null) {
            this.conversionService = (ConversionService)this.applicationContext.getBean("integrationConversionService", ConversionService.class);
        }
    }

    public String getBinder(String bindingName) {
        return this.getBindingProperties(bindingName).getBinder();
    }

    public Map<String, Object> asMapProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("instanceIndex", String.valueOf(this.getInstanceIndex()));
        properties.put("instanceCount", String.valueOf(this.getInstanceCount()));
        properties.put("defaultBinder", this.getDefaultBinder());
        properties.put("dynamicDestinations", this.getDynamicDestinations());
        for (Map.Entry<String, BindingProperties> entry : this.bindings.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().toString());
        }
        for (Map.Entry<String, Object> entry : this.binders.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public ConsumerProperties getConsumerProperties(String inputBindingName) {
        Assert.notNull((Object)inputBindingName, (String)"The input binding name cannot be null");
        BindingProperties bindingProperties = this.getBindingProperties(inputBindingName);
        ConsumerProperties consumerProperties = bindingProperties.getConsumer();
        if (consumerProperties == null) {
            consumerProperties = new ConsumerProperties();
            bindingProperties.setConsumer(consumerProperties);
        }
        if (consumerProperties.getInstanceCount() < 0) {
            consumerProperties.setInstanceCount(this.instanceCount);
        }
        if (consumerProperties.getInstanceIndex() < 0) {
            consumerProperties.setInstanceIndex(this.instanceIndex);
        }
        return consumerProperties;
    }

    public ProducerProperties getProducerProperties(String outputBindingName) {
        Assert.notNull((Object)outputBindingName, (String)"The output binding name cannot be null");
        BindingProperties bindingProperties = this.getBindingProperties(outputBindingName);
        ProducerProperties producerProperties = bindingProperties.getProducer();
        if (producerProperties == null) {
            producerProperties = new ProducerProperties();
            bindingProperties.setProducer(producerProperties);
        }
        return producerProperties;
    }

    public BindingProperties getBindingProperties(String bindingName) {
        BindingProperties bindingProperties = new BindingProperties();
        if (this.bindings.containsKey(bindingName)) {
            BeanUtils.copyProperties((Object)this.bindings.get(bindingName), (Object)bindingProperties);
        }
        if (bindingProperties.getDestination() == null) {
            bindingProperties.setDestination(bindingName);
        }
        return bindingProperties;
    }

    public String getGroup(String bindingName) {
        return this.getBindingProperties(bindingName).getGroup();
    }

    public String getBindingDestination(String bindingName) {
        return this.getBindingProperties(bindingName).getDestination();
    }

    public int getBindingRetryInterval() {
        return this.bindingRetryInterval;
    }

    public void setBindingRetryInterval(int bindingRetryInterval) {
        this.bindingRetryInterval = bindingRetryInterval;
    }

    public void updateProducerProperties(String bindingName, ProducerProperties producerProperties) {
        if (this.bindings.containsKey(bindingName)) {
            this.bindings.get(bindingName).setProducer(producerProperties);
        }
    }
}

