/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.cloud.stream.config.MergableProperties;
import org.springframework.expression.Expression;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ProducerProperties
implements MergableProperties {
    @JsonSerialize(using=ExpressionSerializer.class)
    private Expression partitionKeyExpression;
    @Deprecated
    private Class<?> partitionKeyExtractorClass;
    private String partitionKeyExtractorName;
    @Deprecated
    private Class<?> partitionSelectorClass;
    private String partitionSelectorName;
    @JsonSerialize(using=ExpressionSerializer.class)
    private Expression partitionSelectorExpression;
    private int partitionCount = 1;
    private String[] requiredGroups = new String[0];
    private HeaderMode headerMode;
    private boolean useNativeEncoding = false;
    private boolean errorChannelEnabled = false;

    public Expression getPartitionKeyExpression() {
        return this.partitionKeyExpression;
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    @Deprecated
    public Class<?> getPartitionKeyExtractorClass() {
        return this.partitionKeyExtractorClass;
    }

    @Deprecated
    public void setPartitionKeyExtractorClass(Class<?> partitionKeyExtractorClass) {
        this.partitionKeyExtractorClass = partitionKeyExtractorClass;
    }

    public boolean isPartitioned() {
        return this.partitionCount > 1 || this.partitionKeyExpression != null || this.partitionKeyExtractorName != null || this.partitionKeyExtractorClass != null;
    }

    @Deprecated
    public Class<?> getPartitionSelectorClass() {
        return this.partitionSelectorClass;
    }

    @Deprecated
    public void setPartitionSelectorClass(Class<?> partitionSelectorClass) {
        this.partitionSelectorClass = partitionSelectorClass;
    }

    public Expression getPartitionSelectorExpression() {
        return this.partitionSelectorExpression;
    }

    public void setPartitionSelectorExpression(Expression partitionSelectorExpression) {
        this.partitionSelectorExpression = partitionSelectorExpression;
    }

    @Min(value=1L, message="Partition count should be greater than zero.")
    public @Min(value=1L, message="Partition count should be greater than zero.") int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public String[] getRequiredGroups() {
        return this.requiredGroups;
    }

    public void setRequiredGroups(String ... requiredGroups) {
        this.requiredGroups = requiredGroups;
    }

    @AssertTrue(message="Partition key expression and partition key extractor class properties are mutually exclusive.")
    public @AssertTrue(message="Partition key expression and partition key extractor class properties are mutually exclusive.") boolean isValidPartitionKeyProperty() {
        return this.partitionKeyExpression == null || this.partitionKeyExtractorClass == null;
    }

    @AssertTrue(message="Partition selector class and partition selector expression properties are mutually exclusive.")
    public @AssertTrue(message="Partition selector class and partition selector expression properties are mutually exclusive.") boolean isValidPartitionSelectorProperty() {
        return this.partitionSelectorClass == null || this.partitionSelectorExpression == null;
    }

    public HeaderMode getHeaderMode() {
        return this.headerMode;
    }

    public void setHeaderMode(HeaderMode headerMode) {
        this.headerMode = headerMode;
    }

    public boolean isUseNativeEncoding() {
        return this.useNativeEncoding;
    }

    public void setUseNativeEncoding(boolean useNativeEncoding) {
        this.useNativeEncoding = useNativeEncoding;
    }

    public boolean isErrorChannelEnabled() {
        return this.errorChannelEnabled;
    }

    public void setErrorChannelEnabled(boolean errorChannelEnabled) {
        this.errorChannelEnabled = errorChannelEnabled;
    }

    public String getPartitionKeyExtractorName() {
        return this.partitionKeyExtractorName;
    }

    public void setPartitionKeyExtractorName(String partitionKeyExtractorName) {
        this.partitionKeyExtractorName = partitionKeyExtractorName;
    }

    public String getPartitionSelectorName() {
        return this.partitionSelectorName;
    }

    public void setPartitionSelectorName(String partitionSelectorName) {
        this.partitionSelectorName = partitionSelectorName;
    }

    static class ExpressionSerializer
    extends JsonSerializer<Expression> {
        ExpressionSerializer() {
        }

        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (expression != null) {
                jsonGenerator.writeString(expression.getExpressionString());
            }
        }
    }
}

