/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;

public class InputBindingLifecycle
implements SmartLifecycle,
ApplicationContextAware {
    private volatile boolean running;
    private ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void start() {
        if (!this.running) {
            try {
                BindingService bindingService = (BindingService)this.applicationContext.getBean(BindingService.class);
                Map bindables = this.applicationContext.getBeansOfType(Bindable.class);
                for (Bindable bindable : bindables.values()) {
                    bindable.bindInputs(bindingService);
                }
            }
            catch (BeansException e) {
                throw new IllegalStateException("Cannot perform binding, no proper implementation found", e);
            }
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            try {
                BindingService bindingService = (BindingService)this.applicationContext.getBean(BindingService.class);
                Map bindables = this.applicationContext.getBeansOfType(Bindable.class);
                for (Bindable bindable : bindables.values()) {
                    bindable.unbindInputs(bindingService);
                }
            }
            catch (BeansException e) {
                throw new IllegalStateException("Cannot perform unbinding, no proper implementation found", e);
            }
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public int getPhase() {
        return 2147482647;
    }
}

