/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.cloud.stream.binding.BindableAdapter;
import org.springframework.cloud.stream.binding.ChannelBindingService;
import org.springframework.messaging.MessageChannel;

public class SingleChannelBindable
extends BindableAdapter {
    private final String name;
    private final MessageChannel messageChannel;

    public SingleChannelBindable(String name, MessageChannel messageChannel) {
        this.name = name;
        this.messageChannel = messageChannel;
    }

    @Override
    public void bindOutputs(ChannelBindingService adapter) {
        adapter.bindProducer(this.messageChannel, this.name);
    }

    @Override
    public void unbindOutputs(ChannelBindingService adapter) {
        adapter.unbindProducers(this.name);
    }

    @Override
    public Set<String> getOutputs() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(this.name)));
    }
}

