/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BinderProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cloud.stream")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ChannelBindingServiceProperties
implements ApplicationContextAware,
InitializingBean {
    private ConversionService conversionService;
    @Value(value="${INSTANCE_INDEX:${CF_INSTANCE_INDEX:0}}")
    private int instanceIndex = 0;
    private int instanceCount = 1;
    private Map<String, BindingProperties> bindings = new TreeMap<String, BindingProperties>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, BinderProperties> binders = new HashMap<String, BinderProperties>();
    private Properties consumerDefaults = new Properties();
    private Properties producerDefaults = new Properties();
    private String defaultBinder;
    private String[] dynamicDestinations = new String[0];
    private boolean ignoreUnknownProperties = true;
    private ConfigurableApplicationContext applicationContext;

    public Map<String, BindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, BindingProperties> bindings) {
        this.bindings = bindings;
    }

    public Map<String, BinderProperties> getBinders() {
        return this.binders;
    }

    public void setBinders(Map<String, BinderProperties> binders) {
        this.binders = binders;
    }

    public String getDefaultBinder() {
        return this.defaultBinder;
    }

    public void setDefaultBinder(String defaultBinder) {
        this.defaultBinder = defaultBinder;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(int instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    public String[] getDynamicDestinations() {
        return this.dynamicDestinations;
    }

    public void setDynamicDestinations(String[] dynamicDestinations) {
        this.dynamicDestinations = dynamicDestinations;
    }

    public Properties getConsumerDefaults() {
        return this.consumerDefaults;
    }

    public void setConsumerDefaults(Properties consumerDefaults) {
        this.consumerDefaults = consumerDefaults;
    }

    public Properties getProducerDefaults() {
        return this.producerDefaults;
    }

    public void setProducerDefaults(Properties producerDefaults) {
        this.producerDefaults = producerDefaults;
    }

    public boolean isIgnoreUnknownProperties() {
        return this.ignoreUnknownProperties;
    }

    public void setIgnoreUnknownProperties(boolean ignoreUnknownProperties) {
        this.ignoreUnknownProperties = ignoreUnknownProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.conversionService == null) {
            this.conversionService = (ConversionService)this.applicationContext.getBean("integrationConversionService", ConversionService.class);
        }
    }

    public String getBinder(String channelName) {
        return this.getBindingProperties(channelName).getBinder();
    }

    public Map<String, Object> asMapProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("instanceIndex", String.valueOf(this.getInstanceIndex()));
        properties.put("instanceCount", String.valueOf(this.getInstanceCount()));
        properties.put("defaultBinder", this.getDefaultBinder());
        properties.put("dynamicDestinations", this.getDynamicDestinations());
        for (Map.Entry<String, BindingProperties> entry : this.bindings.entrySet()) {
            properties.put(entry.getKey(), entry.getValue().toString());
        }
        for (Map.Entry<String, Object> entry : this.binders.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public ConsumerProperties getConsumerProperties(String inputChannelName) {
        Assert.notNull((Object)inputChannelName, (String)"The input channel name cannot be null");
        ConsumerProperties consumerProperties = this.getBindingProperties(inputChannelName).getConsumer();
        if (consumerProperties == null) {
            consumerProperties = new ConsumerProperties();
        }
        consumerProperties.setInstanceCount(this.instanceCount);
        consumerProperties.setInstanceIndex(this.instanceIndex);
        return consumerProperties;
    }

    public ProducerProperties getProducerProperties(String outputChannelName) {
        Assert.notNull((Object)outputChannelName, (String)"The output channel name cannot be null");
        ProducerProperties producerProperties = this.getBindingProperties(outputChannelName).getProducer();
        if (producerProperties == null) {
            producerProperties = new ProducerProperties();
        }
        return producerProperties;
    }

    public BindingProperties getBindingProperties(String channelName) {
        BindingProperties bindingProperties = new BindingProperties();
        if (this.bindings.containsKey(channelName)) {
            BeanUtils.copyProperties((Object)this.bindings.get(channelName), (Object)bindingProperties);
        }
        if (bindingProperties.getDestination() == null) {
            bindingProperties.setDestination(channelName);
        }
        return bindingProperties;
    }

    public String getGroup(String channelName) {
        return this.getBindingProperties(channelName).getGroup();
    }

    public String getBindingDestination(String channelName) {
        return this.getBindingProperties(channelName).getDestination();
    }
}

