/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.aggregate.AggregatorParentConfiguration;
import org.springframework.cloud.stream.aggregate.SharedChannelRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.MessageChannel;

class AggregateApplication {
    private static final String SPRING_CLOUD_STREAM_INTERNAL_PREFIX = "spring.cloud.stream.internal";
    public static final String CHANNEL_NAMESPACE_PROPERTY_NAME = "spring.cloud.stream.internal.channelNamespace";
    public static final String INPUT_CHANNEL_NAME = "input";
    public static final String OUTPUT_CHANNEL_NAME = "output";

    AggregateApplication() {
    }

    static ConfigurableApplicationContext run(Class<?>[] apps, String[] parentArgs, String[][] appArgs) {
        ConfigurableApplicationContext parentContext = AggregateApplication.createParentContext(parentArgs != null ? parentArgs : new String[]{});
        AggregateApplication.runEmbedded(parentContext, apps, appArgs);
        return parentContext;
    }

    static ConfigurableApplicationContext run(Class<?> ... apps) {
        return AggregateApplication.run(apps, null, (String[][])null);
    }

    static void runEmbedded(ConfigurableApplicationContext parentContext, Class<?>[] apps, String[][] args) {
        SharedChannelRegistry bean = (SharedChannelRegistry)parentContext.getBean(SharedChannelRegistry.class);
        AggregateApplication.prepareSharedChannelRegistry(bean, apps);
        AggregateApplication.createChildContexts(parentContext, apps, args);
    }

    static ConfigurableApplicationContext createParentContext(String[] args) {
        SpringApplicationBuilder aggregatorParentConfiguration = new SpringApplicationBuilder(new Object[0]);
        aggregatorParentConfiguration.sources(new Class[]{AggregatorParentConfiguration.class}).web(false).headless(true).properties(new String[]{"spring.jmx.default-domain=" + AggregatorParentConfiguration.class.getName()});
        return aggregatorParentConfiguration.run(args);
    }

    static void createChildContexts(ConfigurableApplicationContext parentContext, Class<?>[] apps, String[][] args) {
        for (int i = apps.length - 1; i >= 0; --i) {
            String appClassName = apps[i].getName();
            AggregateApplication.embedApp(parentContext, AggregateApplication.getNamespace(appClassName, i), apps[i]).run(args != null ? args[i] : new String[]{});
        }
    }

    static String getNamespace(String appClassName, int index) {
        return appClassName + "_" + index;
    }

    protected static SpringApplicationBuilder embedApp(ConfigurableApplicationContext applicationContext, String namespace, Class<?> app) {
        return new SpringApplicationBuilder(new Object[]{app}).web(false).bannerMode(Banner.Mode.OFF).properties(new String[]{"spring.jmx.default-domain=" + app}).properties(new String[]{"spring.cloud.stream.internal.channelNamespace=" + namespace}).registerShutdownHook(false).parent(applicationContext);
    }

    static void prepareSharedChannelRegistry(SharedChannelRegistry sharedChannelRegistry, Class<?>[] apps) {
        LinkedHashMap appsToRegister = new LinkedHashMap();
        for (int i = apps.length - 1; i >= 0; --i) {
            String appClassName = apps[i].getName();
            appsToRegister.put(apps[i], AggregateApplication.getNamespace(appClassName, i));
        }
        AggregateApplication.prepareSharedChannelRegistry(sharedChannelRegistry, appsToRegister);
    }

    static void prepareSharedChannelRegistry(SharedChannelRegistry sharedChannelRegistry, LinkedHashMap<Class<?>, String> appsWithNamespace) {
        int i = 0;
        DirectChannel sharedChannel = null;
        for (Map.Entry<Class<?>, String> appEntry : appsWithNamespace.entrySet()) {
            String namespace = appEntry.getValue();
            if (i > 0) {
                sharedChannelRegistry.register(namespace + "." + INPUT_CHANNEL_NAME, (MessageChannel)sharedChannel);
            }
            sharedChannel = new DirectChannel();
            if (i < appsWithNamespace.size() - 1) {
                sharedChannelRegistry.register(namespace + "." + OUTPUT_CHANNEL_NAME, (MessageChannel)sharedChannel);
            }
            ++i;
        }
    }
}

