/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.test;

import java.util.function.Consumer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.test.TestChannelBinderProvisioner;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.core.RecoveryCallback;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.integration.support.MapBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TestChannelBinder
extends AbstractMessageChannelBinder<ConsumerProperties, ProducerProperties, TestChannelBinderProvisioner> {
    @Autowired
    private BeanFactory beanFactory;
    private Message<?> lastError;
    private MessageSource<?> messageSourceDelegate = () -> new GenericMessage((Object)"polled data", new MapBuilder().put((Object)"contentType", (Object)"text/plain").put((Object)"acknowledgmentCallback", status -> {}).get());

    public TestChannelBinder(TestChannelBinderProvisioner provisioningProvider) {
        super(new String[0], (ProvisioningProvider)provisioningProvider);
    }

    @Autowired(required=false)
    public void setMessageSourceDelegate(MessageSource<byte[]> messageSourceDelegate) {
        this.messageSourceDelegate = messageSourceDelegate;
    }

    public Message<?> getLastError() {
        return this.lastError;
    }

    public void resetLastError() {
        this.lastError = null;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ProducerProperties producerProperties, MessageChannel errorChannel) throws Exception {
        BridgeHandler handler = new BridgeHandler();
        handler.setBeanFactory(this.beanFactory);
        handler.setOutputChannel((MessageChannel)((TestChannelBinderProvisioner.SpringIntegrationProducerDestination)destination).getChannel());
        return handler;
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ConsumerProperties properties) throws Exception {
        DefaultErrorMessageStrategy errorMessageStrategy = new DefaultErrorMessageStrategy();
        SubscribableChannel siBinderInputChannel = ((TestChannelBinderProvisioner.SpringIntegrationConsumerDestination)destination).getChannel();
        IntegrationMessageListeningContainer messageListenerContainer = new IntegrationMessageListeningContainer();
        IntegrationBinderInboundChannelAdapter adapter = new IntegrationBinderInboundChannelAdapter(messageListenerContainer);
        adapter.setBeanFactory(this.beanFactory);
        String groupName = StringUtils.hasText((String)group) ? group : "anonymous";
        AbstractMessageChannelBinder.ErrorInfrastructure errorInfrastructure = this.registerErrorInfrastructure(destination, groupName, properties);
        if (properties.getMaxAttempts() > 1) {
            adapter.setRetryTemplate(this.buildRetryTemplate(properties));
            adapter.setRecoveryCallback((RecoveryCallback<?>)errorInfrastructure.getRecoverer());
        } else {
            adapter.setErrorMessageStrategy((ErrorMessageStrategy)errorMessageStrategy);
            adapter.setErrorChannel((MessageChannel)errorInfrastructure.getErrorChannel());
        }
        siBinderInputChannel.subscribe((MessageHandler)messageListenerContainer);
        return adapter;
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ConsumerProperties consumerProperties) {
        return new AbstractMessageChannelBinder.PolledConsumerResources(this.messageSourceDelegate, this.registerErrorInfrastructure(destination, group, consumerProperties));
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, ConsumerProperties consumerProperties) {
        return m -> {
            this.logger.info((Object)("Error handled: " + m));
            this.lastError = m;
        };
    }

    private static class IntegrationMessageListeningContainer
    implements MessageHandler {
        private Consumer<Message<?>> listener;

        private IntegrationMessageListeningContainer() {
        }

        public void handleMessage(Message<?> message) throws MessagingException {
            this.listener.accept(message);
        }

        public void setMessageListener(Consumer<Message<?>> listener) {
            this.listener = listener;
        }
    }

    private static class IntegrationBinderInboundChannelAdapter
    extends MessageProducerSupport {
        private final IntegrationMessageListeningContainer listenerContainer;
        private RetryTemplate retryTemplate;
        private RecoveryCallback<?> recoveryCallback;

        IntegrationBinderInboundChannelAdapter(IntegrationMessageListeningContainer listenerContainer) {
            this.listenerContainer = listenerContainer;
        }

        public void setRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
            this.recoveryCallback = recoveryCallback;
        }

        public void setRetryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
        }

        protected void onInit() {
            if (this.retryTemplate != null) {
                Assert.state((this.getErrorChannel() == null ? 1 : 0) != 0, (String)"Cannot have an 'errorChannel' property when a 'RetryTemplate' is provided; use an 'ErrorMessageSendingRecoverer' in the 'recoveryCallback' property to send an error message when retries are exhausted");
            }
            Listener messageListener = new Listener();
            this.listenerContainer.setMessageListener(messageListener);
        }

        protected class Listener
        implements Consumer<Message<?>> {
            protected Listener() {
            }

            @Override
            public void accept(Message<?> message) {
                try {
                    if (IntegrationBinderInboundChannelAdapter.this.retryTemplate == null) {
                        this.processMessage(message);
                    } else {
                        try {
                            IntegrationBinderInboundChannelAdapter.this.retryTemplate.execute(() -> {
                                this.processMessage(message);
                                return null;
                            });
                        }
                        catch (RetryException ex) {
                            IntegrationBinderInboundChannelAdapter.this.recoveryCallback.recover(ErrorMessageUtils.getAttributeAccessor(message, null), (Throwable)ex);
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (IntegrationBinderInboundChannelAdapter.this.getErrorChannel() != null) {
                        IntegrationBinderInboundChannelAdapter.this.getMessagingTemplate().send((Object)IntegrationBinderInboundChannelAdapter.this.getErrorChannel(), (Message)IntegrationBinderInboundChannelAdapter.this.buildErrorMessage(null, new IllegalStateException("Message conversion failed: " + message, e)));
                    }
                    throw e;
                }
            }

            private void processMessage(Message<?> message) {
                IntegrationBinderInboundChannelAdapter.this.sendMessage(message);
            }
        }
    }
}

