/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import javax.validation.constraints.Min;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.util.Assert;

public class RabbitConsumerProperties {
    private String prefix = "";
    private boolean transacted;
    private AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    private int maxConcurrency = 1;
    private int prefetch = 1;
    private String[] requestHeaderPatterns = new String[]{"STANDARD_REQUEST_HEADERS", "*"};
    private int txSize = 1;
    private boolean autoBindDlq;
    private boolean durableSubscription = true;
    private boolean republishToDlq;
    private boolean requeueRejected = false;
    private String[] replyHeaderPatterns = new String[]{"STANDARD_REPLY_HEADERS", "*"};
    private long recoveryInterval = 5000L;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        Assert.notNull((Object)"Acknowledge mode cannot be null");
        this.acknowledgeMode = acknowledgeMode;
    }

    @Min(value=1L, message="Max Concurrency should be greater than zero.")
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Min(value=1L, message="Prefetch should be greater than zero.")
    public int getPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(int prefetch) {
        this.prefetch = prefetch;
    }

    public String[] getRequestHeaderPatterns() {
        return this.requestHeaderPatterns;
    }

    public void setRequestHeaderPatterns(String[] requestHeaderPatterns) {
        this.requestHeaderPatterns = requestHeaderPatterns;
    }

    @Min(value=1L, message="Tx Size should be greater than zero.")
    public int getTxSize() {
        return this.txSize;
    }

    public void setTxSize(int txSize) {
        this.txSize = txSize;
    }

    public boolean isAutoBindDlq() {
        return this.autoBindDlq;
    }

    public void setAutoBindDlq(boolean autoBindDlq) {
        this.autoBindDlq = autoBindDlq;
    }

    public boolean isDurableSubscription() {
        return this.durableSubscription;
    }

    public void setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
    }

    public boolean isRepublishToDlq() {
        return this.republishToDlq;
    }

    public void setRepublishToDlq(boolean republishToDlq) {
        this.republishToDlq = republishToDlq;
    }

    public boolean isRequeueRejected() {
        return this.requeueRejected;
    }

    public void setRequeueRejected(boolean requeueRejected) {
        this.requeueRejected = requeueRejected;
    }

    public String[] getReplyHeaderPatterns() {
        return this.replyHeaderPatterns;
    }

    public void setReplyHeaderPatterns(String[] replyHeaderPatterns) {
        this.replyHeaderPatterns = replyHeaderPatterns;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }
}

