/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.pulsar.properties;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.pulsar.autoconfigure.PulsarProperties;
import org.springframework.util.Assert;

public class ConsumerConfigProperties
extends PulsarProperties.Consumer {
    private final Acknowledgement ack = new Acknowledgement();
    private final Chunking chunk = new Chunking();
    private final Subscription subscription = new Subscription();
    private Integer receiverQueueSize = 1000;
    private Integer maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private SortedMap<String, String> properties = new TreeMap<String, String>();
    private Integer patternAutoDiscoveryPeriod = 1;
    private Boolean autoUpdatePartitions = true;
    private Duration autoUpdatePartitionsInterval = Duration.ofMinutes(1L);
    private Boolean resetIncludeHead = false;
    private Boolean poolMessages = false;
    private Boolean startPaused = false;

    public Acknowledgement getAck() {
        return this.ack;
    }

    public Chunking getChunk() {
        return this.chunk;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public Integer getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public void setReceiverQueueSize(Integer receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public Integer getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(Integer maxTotalReceiverQueueSizeAcrossPartitions) {
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public Integer getPatternAutoDiscoveryPeriod() {
        return this.patternAutoDiscoveryPeriod;
    }

    public void setPatternAutoDiscoveryPeriod(Integer patternAutoDiscoveryPeriod) {
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
    }

    public Boolean getAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public void setAutoUpdatePartitions(Boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public Duration getAutoUpdatePartitionsInterval() {
        return this.autoUpdatePartitionsInterval;
    }

    public void setAutoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
        this.autoUpdatePartitionsInterval = autoUpdatePartitionsInterval;
    }

    public Boolean getResetIncludeHead() {
        return this.resetIncludeHead;
    }

    public void setResetIncludeHead(Boolean resetIncludeHead) {
        this.resetIncludeHead = resetIncludeHead;
    }

    public Boolean getPoolMessages() {
        return this.poolMessages;
    }

    public void setPoolMessages(Boolean poolMessages) {
        this.poolMessages = poolMessages;
    }

    public Boolean getStartPaused() {
        return this.startPaused;
    }

    public void setStartPaused(Boolean startPaused) {
        this.startPaused = startPaused;
    }

    public Map<String, Object> toBaseConsumerPropertiesMap() {
        Properties consumerProps = new Properties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> ((ConsumerConfigProperties)this).getDeadLetterPolicy()).as(this::toPulsarDeadLetterPolicy).to(consumerProps.in("deadLetterPolicy"));
        map.from(() -> ((ConsumerConfigProperties)this).getName()).to(consumerProps.in("consumerName"));
        map.from(() -> ((ConsumerConfigProperties)this).getPriorityLevel()).to(consumerProps.in("priorityLevel"));
        map.from(() -> ((ConsumerConfigProperties)this).isReadCompacted()).to(consumerProps.in("readCompacted"));
        map.from(() -> ((ConsumerConfigProperties)this).isRetryEnable()).to(consumerProps.in("retryEnable"));
        map.from(() -> ((ConsumerConfigProperties)this).getTopics()).to(consumerProps.in("topicNames"));
        map.from(() -> ((ConsumerConfigProperties)this).getTopicsPattern()).to(consumerProps.in("topicsPattern"));
        this.mapBaseSubscriptionProperties(this.getSubscription(), consumerProps, map);
        return consumerProps;
    }

    private DeadLetterPolicy toPulsarDeadLetterPolicy(PulsarProperties.Consumer.DeadLetterPolicy policy) {
        Assert.state((policy.getMaxRedeliverCount() > 0 ? 1 : 0) != 0, (String)"Pulsar DeadLetterPolicy must have a positive 'max-redelivery-count' property value");
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        DeadLetterPolicy.DeadLetterPolicyBuilder builder = DeadLetterPolicy.builder();
        map.from(() -> ((PulsarProperties.Consumer.DeadLetterPolicy)policy).getMaxRedeliverCount()).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).maxRedeliverCount(arg_0));
        map.from(() -> ((PulsarProperties.Consumer.DeadLetterPolicy)policy).getRetryLetterTopic()).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).retryLetterTopic(arg_0));
        map.from(() -> ((PulsarProperties.Consumer.DeadLetterPolicy)policy).getDeadLetterTopic()).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).deadLetterTopic(arg_0));
        map.from(() -> ((PulsarProperties.Consumer.DeadLetterPolicy)policy).getInitialSubscriptionName()).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).initialSubscriptionName(arg_0));
        return builder.build();
    }

    private void mapBaseSubscriptionProperties(PulsarProperties.Consumer.Subscription subscription, Properties consumerProps, PropertyMapper map) {
        map.from(() -> ((PulsarProperties.Consumer.Subscription)subscription).getName()).to(consumerProps.in("subscriptionName"));
        map.from(() -> ((PulsarProperties.Consumer.Subscription)subscription).getType()).to(consumerProps.in("subscriptionType"));
        map.from(() -> ((PulsarProperties.Consumer.Subscription)subscription).getMode()).to(consumerProps.in("subscriptionMode"));
        map.from(() -> ((PulsarProperties.Consumer.Subscription)subscription).getInitialPosition()).to(consumerProps.in("subscriptionInitialPosition"));
        map.from(() -> ((PulsarProperties.Consumer.Subscription)subscription).getTopicsMode()).to(consumerProps.in("regexSubscriptionMode"));
    }

    public Map<String, Object> toExtendedConsumerPropertiesMap() {
        Properties consumerProps = new Properties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this::getAutoUpdatePartitions).to(consumerProps.in("autoUpdatePartitions"));
        map.from(this::getAutoUpdatePartitionsInterval).as(Duration::toSeconds).to(consumerProps.in("autoUpdatePartitionsIntervalSeconds"));
        map.from(this::getCryptoFailureAction).to(consumerProps.in("cryptoFailureAction"));
        map.from(this::getMaxTotalReceiverQueueSizeAcrossPartitions).to(consumerProps.in("maxTotalReceiverQueueSizeAcrossPartitions"));
        map.from(this::getPatternAutoDiscoveryPeriod).to(consumerProps.in("patternAutoDiscoveryPeriod"));
        map.from(this::getPoolMessages).to(consumerProps.in("poolMessages"));
        map.from(this::getProperties).to(consumerProps.in("properties"));
        map.from(this::getReceiverQueueSize).to(consumerProps.in("receiverQueueSize"));
        map.from(this::getResetIncludeHead).to(consumerProps.in("resetIncludeHead"));
        map.from(this::getStartPaused).to(consumerProps.in("startPaused"));
        this.mapAcknowledgementProperties(this.getAck(), consumerProps, map);
        this.mapChunkProperties(this.getChunk(), consumerProps, map);
        this.mapExtendedSubscriptionProperties(this.getSubscription(), consumerProps, map);
        return consumerProps;
    }

    private void mapAcknowledgementProperties(Acknowledgement ack, Properties consumerProps, PropertyMapper map) {
        map.from(ack::getGroupTime).as(it -> it.toNanos() / 1000L).to(consumerProps.in("acknowledgementsGroupTimeMicros"));
        map.from(ack::getRedeliveryDelay).as(it -> it.toNanos() / 1000L).to(consumerProps.in("negativeAckRedeliveryDelayMicros"));
        map.from(ack::getTimeout).as(Duration::toMillis).to(consumerProps.in("ackTimeoutMillis"));
        map.from(ack::getTimeoutTickDuration).as(Duration::toMillis).to(consumerProps.in("tickDurationMillis"));
        map.from(ack::getBatchIndexEnabled).to(consumerProps.in("batchIndexAckEnabled"));
        map.from(ack::getReceiptEnabled).to(consumerProps.in("ackReceiptEnabled"));
    }

    private void mapChunkProperties(Chunking chunk, Properties consumerProps, PropertyMapper map) {
        map.from(chunk::getExpireTimeIncomplete).as(Duration::toMillis).to(consumerProps.in("expireTimeOfIncompleteChunkedMessageMillis"));
        map.from(chunk::getAutoAckOldestOnQueueFull).to(consumerProps.in("autoAckOldestChunkedMessageOnQueueFull"));
        map.from(chunk::getMaxPendingMessages).to(consumerProps.in("maxPendingChunkedMessage"));
    }

    private void mapExtendedSubscriptionProperties(Subscription subscription, Properties consumerProps, PropertyMapper map) {
        map.from(subscription::getProperties).to(consumerProps.in("subscriptionProperties"));
        map.from(subscription::getReplicateState).to(consumerProps.in("replicateSubscriptionState"));
    }

    public Map<String, Object> toAllConsumerPropertiesMap() {
        Map<String, Object> consumerProps = this.toBaseConsumerPropertiesMap();
        consumerProps.putAll(this.toExtendedConsumerPropertiesMap());
        return consumerProps;
    }

    public static class Acknowledgement {
        private Boolean batchIndexEnabled = false;
        private Duration groupTime = Duration.ofMillis(100L);
        private Boolean receiptEnabled = false;
        private Duration redeliveryDelay = Duration.ofMinutes(1L);
        private Duration timeout = Duration.ZERO;
        private Duration timeoutTickDuration = Duration.ofSeconds(1L);

        public Boolean getBatchIndexEnabled() {
            return this.batchIndexEnabled;
        }

        public void setBatchIndexEnabled(Boolean batchIndexEnabled) {
            this.batchIndexEnabled = batchIndexEnabled;
        }

        public Duration getGroupTime() {
            return this.groupTime;
        }

        public void setGroupTime(Duration groupTime) {
            this.groupTime = groupTime;
        }

        public Boolean getReceiptEnabled() {
            return this.receiptEnabled;
        }

        public void setReceiptEnabled(Boolean receiptEnabled) {
            this.receiptEnabled = receiptEnabled;
        }

        public Duration getRedeliveryDelay() {
            return this.redeliveryDelay;
        }

        public void setRedeliveryDelay(Duration redeliveryDelay) {
            this.redeliveryDelay = redeliveryDelay;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public Duration getTimeoutTickDuration() {
            return this.timeoutTickDuration;
        }

        public void setTimeoutTickDuration(Duration timeoutTickDuration) {
            this.timeoutTickDuration = timeoutTickDuration;
        }
    }

    public static class Chunking {
        private Boolean autoAckOldestOnQueueFull = true;
        private Duration expireTimeIncomplete = Duration.ofMinutes(1L);
        private Integer maxPendingMessages = 10;

        public Boolean getAutoAckOldestOnQueueFull() {
            return this.autoAckOldestOnQueueFull;
        }

        public void setAutoAckOldestOnQueueFull(Boolean autoAckOldestOnQueueFull) {
            this.autoAckOldestOnQueueFull = autoAckOldestOnQueueFull;
        }

        public Duration getExpireTimeIncomplete() {
            return this.expireTimeIncomplete;
        }

        public void setExpireTimeIncomplete(Duration expireTimeIncomplete) {
            this.expireTimeIncomplete = expireTimeIncomplete;
        }

        public Integer getMaxPendingMessages() {
            return this.maxPendingMessages;
        }

        public void setMaxPendingMessages(Integer maxPendingMessages) {
            this.maxPendingMessages = maxPendingMessages;
        }
    }

    public static class Subscription
    extends PulsarProperties.Consumer.Subscription {
        private Map<String, String> properties = new HashMap<String, String>();
        private Boolean replicateState = false;

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Boolean getReplicateState() {
            return this.replicateState;
        }

        public void setReplicateState(Boolean replicateState) {
            this.replicateState = replicateState;
        }
    }

    static class Properties
    extends HashMap<String, Object> {
        Properties() {
        }

        <V> Consumer<V> in(String key) {
            return value -> this.put(key, value);
        }
    }
}

