/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.io.IOException;
import javax.security.auth.login.AppConfigurationEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderMetrics;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderHealthIndicatorConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={KafkaAutoConfiguration.class, PropertyPlaceholderAutoConfiguration.class, KafkaBinderHealthIndicatorConfiguration.class})
@EnableConfigurationProperties(value={KafkaExtendedBindingProperties.class})
public class KafkaBinderConfiguration {
    @Autowired
    private KafkaExtendedBindingProperties kafkaExtendedBindingProperties;
    @Autowired
    private ProducerListener producerListener;
    @Autowired
    private KafkaProperties kafkaProperties;

    @Bean
    KafkaBinderConfigurationProperties configurationProperties() {
        return new KafkaBinderConfigurationProperties();
    }

    @Bean
    KafkaTopicProvisioner provisioningProvider(KafkaBinderConfigurationProperties configurationProperties) {
        return new KafkaTopicProvisioner(configurationProperties, this.kafkaProperties);
    }

    @Bean
    KafkaMessageChannelBinder kafkaMessageChannelBinder(KafkaBinderConfigurationProperties configurationProperties, KafkaTopicProvisioner provisioningProvider) {
        KafkaMessageChannelBinder kafkaMessageChannelBinder = new KafkaMessageChannelBinder(configurationProperties, provisioningProvider);
        kafkaMessageChannelBinder.setProducerListener((ProducerListener<byte[], byte[]>)this.producerListener);
        kafkaMessageChannelBinder.setExtendedBindingProperties(this.kafkaExtendedBindingProperties);
        return kafkaMessageChannelBinder;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    ProducerListener producerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaJaasLoginModuleInitializer.class})
    public KafkaJaasLoginModuleInitializer jaasInitializer(KafkaBinderConfigurationProperties configurationProperties) throws IOException {
        KafkaJaasLoginModuleInitializer kafkaJaasLoginModuleInitializer = new KafkaJaasLoginModuleInitializer();
        JaasLoginModuleConfiguration jaas = configurationProperties.getJaas();
        if (jaas != null) {
            kafkaJaasLoginModuleInitializer.setLoginModule(jaas.getLoginModule());
            KafkaJaasLoginModuleInitializer.ControlFlag controlFlag = null;
            AppConfigurationEntry.LoginModuleControlFlag controlFlagValue = jaas.getControlFlagValue();
            if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.equals(controlFlagValue)) {
                controlFlag = KafkaJaasLoginModuleInitializer.ControlFlag.OPTIONAL;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(controlFlagValue)) {
                controlFlag = KafkaJaasLoginModuleInitializer.ControlFlag.REQUIRED;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(controlFlagValue)) {
                controlFlag = KafkaJaasLoginModuleInitializer.ControlFlag.REQUISITE;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(controlFlagValue)) {
                controlFlag = KafkaJaasLoginModuleInitializer.ControlFlag.SUFFICIENT;
            }
            if (controlFlag != null) {
                kafkaJaasLoginModuleInitializer.setControlFlag(controlFlag);
            }
            kafkaJaasLoginModuleInitializer.setOptions(jaas.getOptions());
        }
        return kafkaJaasLoginModuleInitializer;
    }

    public static class JaasConfigurationProperties {
        private JaasLoginModuleConfiguration kafka;
        private JaasLoginModuleConfiguration zookeeper;
    }

    @Configuration
    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    protected class KafkaBinderMetricsConfiguration {
        protected KafkaBinderMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={KafkaBinderMetrics.class})
        public MeterBinder kafkaBinderMetrics(KafkaMessageChannelBinder kafkaMessageChannelBinder, KafkaBinderConfigurationProperties configurationProperties, MeterRegistry meterRegistry) {
            return new KafkaBinderMetrics(kafkaMessageChannelBinder, configurationProperties, null, meterRegistry);
        }
    }
}

