/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka;

import java.util.HashSet;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.kafka.core.ConsumerFactory;

public class KafkaBinderHealthIndicator
implements HealthIndicator {
    private final KafkaMessageChannelBinder binder;
    private final ConsumerFactory<?, ?> consumerFactory;

    public KafkaBinderHealthIndicator(KafkaMessageChannelBinder binder, ConsumerFactory<?, ?> consumerFactory) {
        this.binder = binder;
        this.consumerFactory = consumerFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Health health() {
        try (Consumer metadataConsumer = this.consumerFactory.createConsumer();){
            Health health;
            HashSet<String> downMessages = new HashSet<String>();
            for (String topic : this.binder.getTopicsInUse().keySet()) {
                List partitionInfos = metadataConsumer.partitionsFor(topic);
                for (PartitionInfo partitionInfo : partitionInfos) {
                    if (!this.binder.getTopicsInUse().get(topic).contains(partitionInfo) || partitionInfo.leader().id() != -1) continue;
                    downMessages.add(partitionInfo.toString());
                }
            }
            if (downMessages.isEmpty()) {
                health = Health.up().build();
                return health;
            }
            health = Health.down().withDetail("Following partitions in use have no leaders: ", (Object)((Object)downMessages).toString()).build();
            return health;
        }
        catch (Exception e) {
            return Health.down((Exception)e).build();
        }
    }
}

