/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.kafka.KafkaBinderHealthIndicator;
import org.springframework.cloud.stream.binder.kafka.KafkaExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.KafkaMessageChannelBinder;
import org.springframework.cloud.stream.binder.kafka.config.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.config.codec.kryo.KryoCodecAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.kafka.support.LoggingProducerListener;
import org.springframework.integration.kafka.support.ProducerListener;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={KryoCodecAutoConfiguration.class, PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={KafkaBinderConfigurationProperties.class, KafkaExtendedBindingProperties.class})
public class KafkaBinderConfiguration {
    @Autowired
    private Codec codec;
    @Autowired
    private KafkaBinderConfigurationProperties configurationProperties;
    @Autowired
    private KafkaExtendedBindingProperties kafkaExtendedBindingProperties;
    @Autowired
    private ProducerListener producerListener;

    @Bean
    KafkaMessageChannelBinder kafkaMessageChannelBinder() {
        KafkaMessageChannelBinder kafkaMessageChannelBinder = new KafkaMessageChannelBinder(this.configurationProperties);
        kafkaMessageChannelBinder.setCodec(this.codec);
        kafkaMessageChannelBinder.setProducerListener(this.producerListener);
        kafkaMessageChannelBinder.setExtendedBindingProperties(this.kafkaExtendedBindingProperties);
        return kafkaMessageChannelBinder;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerListener.class})
    ProducerListener producerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    KafkaBinderHealthIndicator healthIndicator(KafkaMessageChannelBinder kafkaMessageChannelBinder) {
        return new KafkaBinderHealthIndicator(kafkaMessageChannelBinder, this.configurationProperties);
    }
}

