/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams.serde;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.kafka.support.serializer.JsonSerde;

public class CollectionSerde<E>
implements Serde<Collection<E>> {
    private final Serde<Collection<E>> inner;
    private final Class<?> collectionClass;

    public CollectionSerde(Serde<E> serde, Class<?> collectionsClass) {
        this.collectionClass = collectionsClass;
        this.inner = Serdes.serdeFrom(new CollectionSerializer(serde.serializer()), new CollectionDeserializer(serde.deserializer(), collectionsClass));
    }

    public CollectionSerde(Class<?> targetTypeForJsonSerde, Class<?> collectionsClass) {
        this.collectionClass = collectionsClass;
        try (JsonSerde jsonSerde = new JsonSerde(targetTypeForJsonSerde);){
            this.inner = Serdes.serdeFrom(new CollectionSerializer(jsonSerde.serializer()), new CollectionDeserializer(jsonSerde.deserializer(), collectionsClass));
        }
    }

    public Serializer<Collection<E>> serializer() {
        return this.inner.serializer();
    }

    public Deserializer<Collection<E>> deserializer() {
        return this.inner.deserializer();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.serializer().configure(configs, isKey);
        this.inner.deserializer().configure(configs, isKey);
    }

    public void close() {
        this.inner.serializer().close();
        this.inner.deserializer().close();
    }

    private static class CollectionSerializer<E>
    implements Serializer<Collection<E>> {
        private Serializer<E> inner;

        CollectionSerializer(Serializer<E> inner) {
            this.inner = inner;
        }

        CollectionSerializer() {
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] serialize(String topic, Collection<E> collection) {
            int size = collection.size();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            Iterator<E> iterator = collection.iterator();
            try {
                dos.writeInt(size);
                while (iterator.hasNext()) {
                    byte[] bytes = this.inner.serialize(topic, iterator.next());
                    dos.writeInt(bytes.length);
                    dos.write(bytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize the provided collection", e);
            }
            return baos.toByteArray();
        }

        public void close() {
            this.inner.close();
        }
    }

    private static class CollectionDeserializer<E>
    implements Deserializer<Collection<E>> {
        private final Deserializer<E> valueDeserializer;
        private final Class<?> collectionClass;

        CollectionDeserializer(Deserializer<E> valueDeserializer, Class<?> collectionClass) {
            this.valueDeserializer = valueDeserializer;
            this.collectionClass = collectionClass;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public Collection<E> deserialize(String topic, byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            Collection<Object> collection = this.getCollection();
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int records = dataInputStream.readInt();
                for (int i = 0; i < records; ++i) {
                    byte[] valueBytes = new byte[dataInputStream.readInt()];
                    int read = dataInputStream.read(valueBytes);
                    if (read == -1) continue;
                    collection.add(this.valueDeserializer.deserialize(topic, valueBytes));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to deserialize collection", e);
            }
            return collection;
        }

        public void close() {
        }

        private Collection<E> getCollection() {
            AbstractCollection collection;
            if (this.collectionClass.isAssignableFrom(ArrayList.class)) {
                collection = new ArrayList();
            } else if (this.collectionClass.isAssignableFrom(HashSet.class)) {
                collection = new HashSet();
            } else if (this.collectionClass.isAssignableFrom(LinkedList.class)) {
                collection = new LinkedList();
            } else if (this.collectionClass.isAssignableFrom(PriorityQueue.class)) {
                collection = new PriorityQueue();
            } else {
                throw new IllegalArgumentException("Unsupported collection type - " + this.collectionClass);
            }
            return collection;
        }
    }
}

