/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;

public class EncodingDecodingBindAdviceHandler
implements ConfigurationPropertiesBindHandlerAdvisor {
    private boolean encodingSettingProvided;
    private boolean decodingSettingProvided;

    public boolean isDecodingSettingProvided() {
        return this.decodingSettingProvided;
    }

    public boolean isEncodingSettingProvided() {
        return this.encodingSettingProvided;
    }

    public BindHandler apply(final BindHandler bindHandler) {
        AbstractBindHandler handler = new AbstractBindHandler(bindHandler){

            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                BindResult result;
                String configName = name.toString();
                if (configName.contains("use") && configName.contains("native") && (configName.contains("encoding") || configName.contains("decoding")) && (result = context.getBinder().bind(name, target)).isBound()) {
                    if (configName.contains("encoding")) {
                        EncodingDecodingBindAdviceHandler.this.encodingSettingProvided = true;
                    } else {
                        EncodingDecodingBindAdviceHandler.this.decodingSettingProvided = true;
                    }
                    return target.withExistingValue(result.get());
                }
                return bindHandler.onStart(name, target, context);
            }
        };
        return handler;
    }
}

