/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.kstream.KStream;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.util.CollectionUtils;

public class KafkaStreamsBindingInformationCatalogue {
    private final Map<KStream<?, ?>, BindingProperties> bindingProperties = new ConcurrentHashMap();
    private final Map<KStream<?, ?>, KafkaStreamsConsumerProperties> consumerProperties = new ConcurrentHashMap();
    private final Map<String, StreamsBuilderFactoryBean> streamsBuilderFactoryBeanPerBinding = new HashMap<String, StreamsBuilderFactoryBean>();
    private final Map<Object, ResolvableType> outboundKStreamResolvables = new HashMap<Object, ResolvableType>();
    private final Map<KStream<?, ?>, Serde<?>> keySerdeInfo = new HashMap();
    private final Map<Object, String> bindingNamesPerTarget = new HashMap<Object, String>();
    private final Map<String, KafkaStreams> previousKafkaStreamsPerApplicationId = new HashMap<String, KafkaStreams>();
    private final Map<StreamsBuilderFactoryBean, List<ProducerFactory<byte[], byte[]>>> dlqProducerFactories = new HashMap<StreamsBuilderFactoryBean, List<ProducerFactory<byte[], byte[]>>>();

    String getDestination(KStream<?, ?> bindingTarget) {
        BindingProperties bindingProperties = this.bindingProperties.get(bindingTarget);
        return bindingProperties.getDestination();
    }

    boolean isUseNativeDecoding(KStream<?, ?> bindingTarget) {
        BindingProperties bindingProperties = this.bindingProperties.get(bindingTarget);
        if (bindingProperties.getConsumer() == null) {
            bindingProperties.setConsumer(new ConsumerProperties());
        }
        return bindingProperties.getConsumer().isUseNativeDecoding();
    }

    boolean isDlqEnabled(KStream<?, ?> bindingTarget) {
        return this.consumerProperties.get(bindingTarget).isEnableDlq();
    }

    String getContentType(KStream<?, ?> bindingTarget) {
        BindingProperties bindingProperties = this.bindingProperties.get(bindingTarget);
        return bindingProperties.getContentType();
    }

    void registerBindingProperties(KStream<?, ?> bindingTarget, BindingProperties bindingProperties) {
        if (bindingProperties != null) {
            this.bindingProperties.put(bindingTarget, bindingProperties);
        }
    }

    void registerConsumerProperties(KStream<?, ?> bindingTarget, KafkaStreamsConsumerProperties kafkaStreamsConsumerProperties) {
        if (kafkaStreamsConsumerProperties != null) {
            this.consumerProperties.put(bindingTarget, kafkaStreamsConsumerProperties);
        }
    }

    Set<StreamsBuilderFactoryBean> getStreamsBuilderFactoryBeans() {
        return new HashSet<StreamsBuilderFactoryBean>(this.streamsBuilderFactoryBeanPerBinding.values());
    }

    void addStreamBuilderFactoryPerBinding(String binding, StreamsBuilderFactoryBean streamsBuilderFactoryBean) {
        this.streamsBuilderFactoryBeanPerBinding.put(binding, streamsBuilderFactoryBean);
    }

    Map<String, StreamsBuilderFactoryBean> getStreamsBuilderFactoryBeanPerBinding() {
        return this.streamsBuilderFactoryBeanPerBinding;
    }

    void addOutboundKStreamResolvable(Object key, ResolvableType outboundResolvable) {
        this.outboundKStreamResolvables.put(key, outboundResolvable);
    }

    ResolvableType getOutboundKStreamResolvable(Object key) {
        return this.outboundKStreamResolvables.get(key);
    }

    void addKeySerde(KStream<?, ?> kStreamTarget, Serde<?> keySerde) {
        this.keySerdeInfo.put(kStreamTarget, keySerde);
    }

    Serde<?> getKeySerde(KStream<?, ?> kStreamTarget) {
        return this.keySerdeInfo.get(kStreamTarget);
    }

    Map<KStream<?, ?>, BindingProperties> getBindingProperties() {
        return this.bindingProperties;
    }

    Map<KStream<?, ?>, KafkaStreamsConsumerProperties> getConsumerProperties() {
        return this.consumerProperties;
    }

    void addBindingNamePerTarget(Object target, String bindingName) {
        this.bindingNamesPerTarget.put(target, bindingName);
    }

    String bindingNamePerTarget(Object target) {
        return this.bindingNamesPerTarget.get(target);
    }

    public List<ProducerFactory<byte[], byte[]>> getDlqProducerFactories() {
        return this.dlqProducerFactories.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ProducerFactory<byte[], byte[]>> getDlqProducerFactory(StreamsBuilderFactoryBean streamsBuilderFactoryBean) {
        return this.dlqProducerFactories.get(streamsBuilderFactoryBean);
    }

    public void addDlqProducerFactory(StreamsBuilderFactoryBean streamsBuilderFactoryBean, ProducerFactory<byte[], byte[]> producerFactory) {
        List<ProducerFactory<byte[], byte[]>> producerFactories = this.dlqProducerFactories.get(streamsBuilderFactoryBean);
        if (CollectionUtils.isEmpty(producerFactories)) {
            producerFactories = new ArrayList<ProducerFactory<byte[], byte[]>>();
            this.dlqProducerFactories.put(streamsBuilderFactoryBean, producerFactories);
        }
        producerFactories.add(producerFactory);
    }

    public void addPreviousKafkaStreamsForApplicationId(String applicationId, KafkaStreams kafkaStreams) {
        this.previousKafkaStreamsPerApplicationId.put(applicationId, kafkaStreams);
    }

    public void removePreviousKafkaStreamsForApplicationId(String applicationId) {
        this.previousKafkaStreamsPerApplicationId.remove(applicationId);
    }

    public Map<String, KafkaStreams> getStoppedKafkaStreams() {
        return this.previousKafkaStreamsPerApplicationId;
    }
}

